/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Database;

import at.pcgamingfreaks.Config.YamlFileManager;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Database.ILanguage;
import at.pcgamingfreaks.MarriageMaster.MagicValues;
import at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.Version;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class Language
extends at.pcgamingfreaks.Bukkit.Config.Language
implements ILanguage {
    public static final String NO_PLACEHOLDER = "&cMarriage Master placeholder not found! Check your language file!";
    private static final String PLACEHOLDERS_KEY = "Placeholders.";
    private static final String HEART = MessageColor.RED + "\u2764" + MessageColor.RESET;
    private static final String SMALLHEART = MessageColor.RED + "\u2665" + MessageColor.RESET;
    private static final String PLACEHOLDER_HEART = "<heart>";
    private static final String PLACEHOLDER_SMALLHEART = "<smallheart>";

    public Language(@NotNull MarriageMaster plugin) {
        super((IPlugin)plugin, new Version(MagicValues.LANG_VERSION));
    }

    protected void doUpgrade(@NotNull YamlFileManager oldLang) {
        if (oldLang.version().olderThan(new Version(90))) {
            this.getLogger().warning(ConsoleColor.RED + "Your language file is from v1.x and is not compatible with versions newer than 2.5!" + ConsoleColor.RESET);
        } else {
            HashMap<String, String> remapping = new HashMap<String, String>();
            remapping.put("Command.Main", "Command.Marry");
            super.doUpgrade(oldLang, remapping);
            if (oldLang.version().olderThan(new Version(110))) {
                this.fixListFooter("Language.Ingame.List.Footer");
                this.fixListFooter("Language.Ingame.ListPriests.Footer");
            }
        }
    }

    private void fixListFooter(String listFooterKey) {
        String listFooter = this.getLangE().getString(listFooterKey, null);
        if (listFooter != null && listFooter.startsWith("[{")) {
            this.getLangE().set(listFooterKey, (Object)("[\"\"," + listFooter.substring(1)));
        }
    }

    @Override
    @NotNull
    public String getTranslated(@NotNull String path) {
        return super.getTranslated(path).replace(PLACEHOLDER_HEART, HEART).replace(PLACEHOLDER_SMALLHEART, SMALLHEART);
    }

    public boolean isPlaceholderSet(@NotNull String key) {
        return this.getLangE().isSet(PLACEHOLDERS_KEY + key);
    }

    @Override
    @NotNull
    public String getTranslatedPlaceholder(@NotNull String key) {
        return MessageColor.translateAlternateColorAndFormatCodes((String)this.getLangE().getString(PLACEHOLDERS_KEY + key, NO_PLACEHOLDER)).replace(PLACEHOLDER_HEART, "\u2764").replace(PLACEHOLDER_SMALLHEART, "\u2665");
    }

    @Override
    @NotNull
    public String getDialog(@NotNull String key) {
        return this.getLangE().getString("Dialog." + key, "").replace(PLACEHOLDER_HEART, HEART).replace(PLACEHOLDER_SMALLHEART, SMALLHEART);
    }
}

