/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Database;

import at.pcgamingfreaks.Bukkit.Database.Cache.UnCacheStrategies.UnCacheStrategyMaker;
import at.pcgamingfreaks.Database.Cache.BaseUnCacheStrategy;
import at.pcgamingfreaks.Database.Cache.IPlayerCache;
import at.pcgamingfreaks.Database.Cache.IUnCacheStrategyConfig;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriageData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriageHome;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.PlatformSpecific;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Database.BaseDatabase;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class Database
extends BaseDatabase<MarriageMaster, MarriagePlayerData, MarriageData, MarriageHome>
implements Listener {
    private final BaseUnCacheStrategy unCacheStrategy;

    public Database(@NotNull MarriageMaster plugin) {
        super(plugin, plugin.getLogger(), new PlatformSpecific(plugin), plugin.getConfiguration(), plugin.getDescription().getName(), plugin.getDataFolder(), plugin.getConfiguration().isBungeeEnabled(), false);
        if (this.available()) {
            this.unCacheStrategy = UnCacheStrategyMaker.make((Plugin)plugin, (IPlayerCache)this.cache, (IUnCacheStrategyConfig)plugin.getConfiguration());
            Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
            if (!plugin.getConfiguration().isBungeeEnabled() || !plugin.getServer().getOnlinePlayers().isEmpty()) {
                new Thread(this.loadRunnable).start();
            }
        } else {
            this.unCacheStrategy = null;
        }
    }

    @Override
    public void close() {
        this.unCacheStrategy.close();
        super.close();
        HandlerList.unregisterAll((Listener)this);
    }

    public MarriagePlayerData getPlayer(OfflinePlayer bPlayer) {
        MarriagePlayerData player = (MarriagePlayerData)this.cache.getPlayer(bPlayer.getUniqueId());
        if (player == null) {
            player = new MarriagePlayerData(bPlayer);
            this.cache.cache(player);
            this.load(player);
        }
        return player;
    }

    @Override
    public MarriagePlayerData getPlayer(UUID uuid) {
        MarriagePlayerData player = (MarriagePlayerData)this.cache.getPlayer(uuid);
        if (player == null) {
            Player bPlayer = Bukkit.getPlayer((UUID)uuid);
            if (bPlayer == null) {
                bPlayer = Bukkit.getOfflinePlayer((UUID)uuid);
            }
            player = new MarriagePlayerData((OfflinePlayer)bPlayer);
            this.cache.cache(player);
            this.load(player);
        }
        return player;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLoginEvent(PlayerJoinEvent event) {
        this.handlePlayerJoin(event.getPlayer());
    }

    private void handlePlayerJoin(Player bPlayer) {
        MarriagePlayerData player = (MarriagePlayerData)this.cache.getPlayer(bPlayer.getUniqueId());
        if (player == null) {
            player = new MarriagePlayerData((OfflinePlayer)bPlayer);
            this.cache.cache(player);
        }
        if (this.bungee) {
            if (player.getDatabaseKey() == null) {
                MarriagePlayerData fPlayer = player;
                ((MarriageMaster)this.plugin).getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.load(fPlayer), 10L);
            } else if (!player.getName().equals(bPlayer.getName())) {
                player.setName(bPlayer.getName());
            }
        } else {
            this.load(player);
        }
    }

    @Override
    protected void loadOnlinePlayers() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            this.handlePlayerJoin(player);
        }
    }
}

