/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Database;

import at.pcgamingfreaks.Bukkit.MinecraftMaterial;
import at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.Config.Configuration;
import at.pcgamingfreaks.Config.ILanguageConfiguration;
import at.pcgamingfreaks.Config.YamlFileManager;
import at.pcgamingfreaks.Config.YamlFileUpdateMethod;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Range;
import at.pcgamingfreaks.MarriageMaster.Bukkit.SpecialInfoWorker.UpgradedInfo;
import at.pcgamingfreaks.MarriageMaster.Database.DatabaseConfiguration;
import at.pcgamingfreaks.MarriageMaster.MagicValues;
import at.pcgamingfreaks.Message.MessageColor;
import at.pcgamingfreaks.Plugin.IPlugin;
import at.pcgamingfreaks.StringUtils;
import at.pcgamingfreaks.Version;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config
extends Configuration
implements DatabaseConfiguration,
ILanguageConfiguration {
    private static final String KEY_SERVER_NAME = "Misc.ServerName";

    public Config(@NotNull MarriageMaster plugin) {
        super((IPlugin)plugin, new Version(MagicValues.CONFIG_VERSION));
    }

    @Nullable
    protected YamlFileUpdateMethod getYamlUpdateMode() {
        return YamlFileUpdateMethod.UPGRADE;
    }

    protected void doUpgrade(@NotNull YamlFileManager oldConfig) {
        if (oldConfig.version().olderThan(new Version(90))) {
            this.getLogger().warning(ConsoleColor.RED + "Your config file is from v1.x and is not compatible with versions newer than 2.5!" + ConsoleColor.RESET);
            new UpgradedInfo(MarriageMaster.getInstance());
        } else {
            HashMap<String, String> reMappings = new HashMap<String, String>();
            if (oldConfig.version().olderThan(new Version(98))) {
                reMappings.put("Misc.AutoUpdate.Enable", "Misc.AutoUpdate");
            }
            if (oldConfig.version().olderThan(new Version(101))) {
                reMappings.put("Database.Cache.UnCache.Strategy", "Database.Cache.UnCache.Strategie");
            }
            Collection keysToKeep = oldConfig.getYamlE().getKeysFiltered("Database\\.SQL\\.(Tables\\.Fields\\..+|MaxLifetime|IdleTimeout)");
            keysToKeep.add(KEY_SERVER_NAME);
            super.doUpgrade(oldConfig, reMappings, keysToKeep);
        }
    }

    private Set<GameMode> getGameModes(@NotNull String key, @Nullable GameMode fallback) {
        List modes = this.getConfigE().getStringList(key, new ArrayList(0)).stream().map(mode -> (GameMode)Utils.getEnum((String)mode, (Enum)((GameMode)null), GameMode.class)).filter(Objects::nonNull).collect(Collectors.toList());
        if (modes.isEmpty()) {
            if (fallback != null) {
                modes.add(fallback);
            } else {
                return EnumSet.noneOf(GameMode.class);
            }
        }
        return EnumSet.copyOf(modes);
    }

    private boolean getAutoableBoolean(@NotNull String key, @NotNull String defaultValue, boolean autoValue) {
        String val;
        switch (val = this.getConfigE().getString(key, defaultValue).trim().toLowerCase(Locale.ENGLISH)) {
            case "1": 
            case "on": 
            case "yes": 
            case "true": {
                return true;
            }
            case "0": 
            case "off": 
            case "no": 
            case "false": {
                return false;
            }
        }
        return autoValue;
    }

    public boolean areMultiplePartnersAllowed() {
        return this.getConfigE().getBoolean("Marriage.AllowMultiplePartners", false);
    }

    public boolean isSelfMarriageAllowed() {
        return !this.getConfigE().getBoolean("Marriage.RequirePriest", true);
    }

    public boolean isSelfDivorceAllowed() {
        return !this.getAutoableBoolean("Marriage.DivorceRequiresPriest", "auto", !this.isSelfMarriageAllowed());
    }

    public boolean isSurnamesEnabled() {
        return this.getConfigE().getBoolean("Marriage.Surnames.Enable", false);
    }

    public boolean isSurnamesForced() {
        return this.getConfigE().getBoolean("Marriage.Surnames.Force", false);
    }

    public double getRange(Range option) {
        return this.getConfigE().getDouble("Range." + option.name(), 25.0);
    }

    public double getRangeSquared(Range option) {
        double range = this.getRange(option);
        return range > 0.0 ? range * range : range;
    }

    public boolean isMarryAnnouncementEnabled() {
        return this.getConfigE().getBoolean("Marriage.AnnounceOnMarriage", true);
    }

    public boolean isDivorceAnnouncementEnabled() {
        return this.getAutoableBoolean("Marriage.AnnounceOnDivorce", "auto", this.isMarryAnnouncementEnabled());
    }

    public boolean isSetPriestCommandEnabled() {
        return !this.getConfigE().getBoolean("Marriage.DisableSetPriestCommand", false);
    }

    public boolean isMarryConfirmationEnabled() {
        return this.getConfigE().getBoolean("Marriage.Confirmation.Enable", true);
    }

    public boolean isMarryConfirmationAutoDialogEnabled() {
        return this.getConfigE().getBoolean("Marriage.Confirmation.AutoDialog", true);
    }

    public boolean isConfirmationBothPlayersOnDivorceEnabled() {
        return this.getConfigE().getBoolean("Marriage.Confirmation.BothPlayersOnDivorce", true);
    }

    public boolean isConfirmationOtherPlayerOnSelfDivorceEnabled() {
        return this.getConfigE().getBoolean("Marriage.Confirmation.OtherPlayerOnSelfDivorce", false);
    }

    public boolean getSurnamesAllowColors() {
        return this.getConfigE().getBoolean("Marriage.Surnames.AllowColors", false);
    }

    public String getSurnamesAllowedCharacters() {
        return this.getConfigE().getString("Marriage.Surnames.AllowedCharacters", "A-Za-z");
    }

    public int getSurnamesMinLength() {
        return Math.max(this.getConfigE().getInt("Marriage.Surnames.MinLength", 3), 3);
    }

    public int getSurnamesMaxLength() {
        return Math.max(this.getConfigE().getInt("Marriage.Surnames.MaxLength", 16), this.getSurnamesMinLength());
    }

    public boolean useListFooter() {
        return this.getConfigE().getBoolean("List.UseFooter", true);
    }

    public int getListEntriesPerPage() {
        return this.getConfigE().getInt("List.EntriesPerPage", 8);
    }

    public int getTPDelayTime() {
        return this.getConfigE().getBoolean("Teleport.Delay", false) ? this.getConfigE().getInt("Teleport.DelayTime", 3) : 0;
    }

    public Set<String> getTPBlackListedWorlds() {
        HashSet<String> blackListedWorlds = new HashSet<String>();
        for (String world : this.getConfigE().getStringList("Teleport.BlacklistedWorlds", new LinkedList())) {
            blackListedWorlds.add(world.toLowerCase(Locale.ENGLISH));
        }
        return blackListedWorlds;
    }

    public boolean getSafetyCheck() {
        return this.getConfigE().getBoolean("Teleport.CheckSafety", true);
    }

    public boolean getRequireConfirmation() {
        return this.getConfigE().getBoolean("Teleport.RequireConfirmation", true);
    }

    public boolean isKissEnabled() {
        return this.getConfigE().getBoolean("Kiss.Enable", true);
    }

    public boolean isKissInteractEnabled() {
        return this.getConfigE().getBoolean("Kiss.EnableInteract", true);
    }

    public int getKissWaitTime() {
        return (int)(this.getConfigE().getFloat("Kiss.WaitTime", 10.0f) * 1000.0f);
    }

    public int getKissHearthCount() {
        return this.getConfigE().getInt("Kiss.HearthCount", 50);
    }

    public boolean isHugEnabled() {
        return this.getConfigE().getBoolean("Hug.Enable", true);
    }

    public boolean isHugInteractEnabled() {
        return this.getConfigE().getBoolean("Hug.EnableInteract", true);
    }

    public int getHugWaitTime() {
        return (int)(this.getConfigE().getFloat("Hug.WaitTime", 10.0f) * 1000.0f);
    }

    public boolean isGiftEnabled() {
        return this.getConfigE().getBoolean("Gift.Enable", true);
    }

    public Set<GameMode> getGiftAllowedGameModes() {
        return this.getGameModes("Gift.AllowedGameModesAllowed", GameMode.SURVIVAL);
    }

    public Set<GameMode> getGiftAllowedReceiveGameModes() {
        return this.getGameModes("Gift.AllowedGameModesReceive", GameMode.SURVIVAL);
    }

    public boolean isGiftRequireConfirmationEnabled() {
        return this.getConfigE().getBoolean("Gift.RequireConfirmation", false);
    }

    public Set<String> getGiftBlackListedWorlds() {
        HashSet<String> blackListedWorlds = new HashSet<String>();
        for (String world : this.getConfigE().getStringList("Gift.BlacklistedWorlds", new LinkedList())) {
            blackListedWorlds.add(world.toLowerCase(Locale.ENGLISH));
        }
        return blackListedWorlds;
    }

    public boolean isGiftItemFilterEnabled() {
        return this.getConfigE().getBoolean("Gift.ItemFilter.Enabled", false);
    }

    public Collection<MinecraftMaterial> getItemFilterMaterials() {
        List stringMaterialList = this.getConfigE().getStringList("Gift.ItemFilter.Materials", new LinkedList());
        ArrayList<MinecraftMaterial> blacklist = new ArrayList<MinecraftMaterial>(stringMaterialList.size());
        for (String item : stringMaterialList) {
            MinecraftMaterial mat = MinecraftMaterial.fromInput((String)item);
            if (mat == null) continue;
            blacklist.add(mat);
        }
        return blacklist;
    }

    public Set<String> getGiftItemFilterNames() {
        HashSet<String> names = new HashSet<String>();
        this.getConfigE().getStringList("Gift.ItemFilter.Names", new ArrayList(0)).forEach(name -> names.add(MessageColor.translateAlternateColorAndFormatCodes((String)name)));
        return names;
    }

    public Set<String> getGiftItemFilterLore() {
        HashSet<String> loreSet = new HashSet<String>();
        this.getConfigE().getStringList("Gift.ItemFilter.Lore", new ArrayList(0)).forEach(lore -> loreSet.add(MessageColor.translateAlternateColorAndFormatCodes((String)lore)));
        return loreSet;
    }

    public boolean isGiftItemFilterModeWhitelist() {
        return StringUtils.arrayContains((String[])new String[]{"whitelist", "allowlist"}, (String)this.getConfigE().getString("Gift.ItemFilter.Mode", "blacklist").toLowerCase(Locale.ENGLISH));
    }

    public boolean getPvPAllowBlocking() {
        return this.getConfigE().getBoolean("PvP.AllowBlocking", true);
    }

    public boolean isBonusXPEnabled() {
        return this.getConfigE().getBoolean("BonusXp.Enable", false);
    }

    public double getBonusXpMultiplier() {
        return this.getConfigE().getDouble("BonusXp.Multiplier", 2.0);
    }

    public boolean isBonusXPSplitOnPickupEnabled() {
        return this.getConfigE().getBoolean("BonusXp.SplitXpOnPickup", true);
    }

    public boolean isBonusXPSplitOnPickupWithAllEnabled() {
        return this.getConfigE().getBoolean("BonusXp.SplitWithAllPartnersInRange", true) && this.isBonusXPSplitOnPickupEnabled();
    }

    public boolean isSkillApiBonusXPEnabled() {
        return this.getConfigE().getBoolean("BonusXp.SkillAPI.Enable", false);
    }

    public List<String> getSkillApiBonusXpBlockedSources() {
        return this.getConfigE().getStringList("BonusXp.SkillAPI.ExcludeSources", new ArrayList(0));
    }

    public double getSkillApiBonusXpMultiplier() {
        return this.getConfigE().getDouble("BonusXp.SkillAPI.Multiplier", 2.0);
    }

    public boolean isSkillApiBonusXPSplitEnabled() {
        return this.getConfigE().getBoolean("BonusXp.SkillAPI.SplitXp", true);
    }

    public boolean isSkillApiBonusXPSplitWithAllEnabled() {
        return this.getConfigE().getBoolean("BonusXp.SkillAPI.SplitWithAllPartnersInRange", true) && this.isSkillApiBonusXPSplitEnabled();
    }

    public boolean isMcMMOBonusXPEnabled() {
        return this.getConfigE().getBoolean("BonusXp.McMMO.Enable", false);
    }

    public Set<String> getMcMMOBonusXpBlockedSources() {
        HashSet<String> blockedSources = new HashSet<String>();
        this.getConfigE().getStringList("BonusXp.McMMO.ExcludeSources", new LinkedList()).forEach(source -> blockedSources.add(source.toUpperCase(Locale.ENGLISH)));
        return blockedSources;
    }

    public Set<String> getMcMMOBonusXpBlockedSkills() {
        HashSet<String> blockedSkills = new HashSet<String>();
        this.getConfigE().getStringList("BonusXp.McMMO.ExcludeSkills", new LinkedList()).forEach(source -> blockedSkills.add(source.toUpperCase(Locale.ENGLISH)));
        return blockedSkills;
    }

    public float getMcMMOBonusXpMultiplier() {
        return this.getConfigE().getFloat("BonusXp.McMMO.Multiplier", 2.0f);
    }

    public boolean isMcMMOBonusXPSplitEnabled() {
        return this.getConfigE().getBoolean("BonusXp.McMMO.SplitXp", true);
    }

    public boolean isMcMMOBonusXPSplitWithAllEnabled() {
        return this.getConfigE().getBoolean("BonusXp.McMMO.SplitWithAllPartnersInRange", true) && this.isMcMMOBonusXPSplitEnabled();
    }

    public boolean isHPRegainEnabled() {
        return this.getConfigE().getBoolean("HealthRegain.Enable", false);
    }

    public double getHPRegainMultiplier() {
        return this.getConfigE().getDouble("HealthRegain.Multiplier", 2.0);
    }

    @Override
    @NotNull
    public String getDatabaseType() {
        return this.getConfigE().getString("Database.Type", "SQLite").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void setDatabaseType(@NotNull String newType) {
        this.set("Database.Type", newType);
        this.trySave();
    }

    @Override
    public boolean useOnlineUUIDs() {
        String type = this.getConfigE().getString("Database.UUID_Type", "auto").toLowerCase(Locale.ENGLISH);
        if (type.equals("auto")) {
            if (this.isBungeeEnabled()) {
                this.getLogger().warning("When using BungeeCord please make sure to set the UUID_Type config option explicitly!");
            }
            return Bukkit.getServer().getOnlineMode();
        }
        return type.equals("online");
    }

    public void setUseUUIDSeparators(boolean useUUIDSeparators) {
        this.set("Database.UseUUIDSeparators", useUUIDSeparators);
        this.trySave();
    }

    public void setUUIDType(String type) {
        this.set("Database.UUID_Type", type);
        this.trySave();
    }

    public boolean isJoinLeaveInfoEnabled() {
        return this.getConfigE().getBoolean("InfoOnPartnerJoinLeave.Enable", true);
    }

    public long getJoinInfoDelay() {
        return this.getConfigE().getLong("InfoOnPartnerJoinLeave.JoinDelay", 0L) * 20L;
    }

    public boolean isChatEnabled() {
        return this.getConfigE().getBoolean("Chat.Enabled", true);
    }

    public boolean isChatSurveillanceEnabled() {
        return this.getConfigE().getBoolean("Chat.AllowSurveillance", false);
    }

    public boolean isPrefixEnabled() {
        return this.getConfigE().getBoolean("Prefix.Enable", false) && !this.getPrefix().isEmpty();
    }

    public boolean isSuffixEnabled() {
        return this.getConfigE().getBoolean("Suffix.Enable", false) && !this.getSuffix().isEmpty();
    }

    @NotNull
    public String getPrefix() {
        return MessageColor.translateAlternateColorAndFormatCodes((String)this.getConfigE().getString("Prefix.String", "").replace("<heart>", MessageColor.RED + "\u2764" + MessageColor.WHITE));
    }

    public boolean isPrefixOnLineBeginning() {
        return this.getConfigE().getBoolean("Prefix.OnLineBeginning", true);
    }

    @NotNull
    public String getSuffix() {
        return MessageColor.translateAlternateColorAndFormatCodes((String)this.getConfigE().getString("Suffix.String", "").replace("<heart>", MessageColor.RED + "\u2764" + MessageColor.WHITE));
    }

    public boolean isBackpackShareEnabled() {
        return this.getConfigE().getBoolean("BackpackShare.Enable", true);
    }

    public boolean isEconomyEnabled() {
        return this.getConfigE().getBoolean("Economy.Enable", false);
    }

    public double getEconomyValue(String valueName) {
        return this.getConfigE().getDouble("Economy." + valueName, 0.0);
    }

    public boolean isCommandExecutorEnabled() {
        return this.getConfigE().getBoolean("CommandExecutor.Enable", false);
    }

    public Collection<String> getCommandExecutorOnMarry() {
        return this.getConfigE().getStringList("CommandExecutor.OnMarry", new LinkedList());
    }

    public Collection<String> getCommandExecutorOnMarryWithPriest() {
        return this.getConfigE().getStringList("CommandExecutor.OnMarryWithPriest", new LinkedList());
    }

    public Collection<String> getCommandExecutorOnDivorce() {
        return this.getConfigE().getStringList("CommandExecutor.OnDivorce", new LinkedList());
    }

    public Collection<String> getCommandExecutorOnDivorceWithPriest() {
        return this.getConfigE().getStringList("CommandExecutor.OnDivorceWithPriest", new LinkedList());
    }

    public String getDefaultCommand() {
        return this.getConfigE().getString("DefaultCommand", "help").toLowerCase(Locale.ENGLISH);
    }

    public boolean isAllowPlayersToChangeMarriageColor() {
        return this.getConfigE().getBoolean("AllowPlayersToChangeMarriageColor", true);
    }

    public boolean useUpdater() {
        return this.getConfigE().getBoolean("Misc.AutoUpdate.Enable", this.getConfigE().getBoolean("Misc.AutoUpdate", true));
    }

    public String getUpdateChannel() {
        String channel = this.getConfigE().getString("Misc.AutoUpdate.Channel", "Release");
        if ("Release".equals(channel) || "Master".equals(channel) || "Dev".equals(channel)) {
            return channel;
        }
        this.getLogger().info("Unknown update Channel: " + channel);
        return null;
    }

    public boolean isBungeeEnabled() {
        boolean shareableDB;
        boolean useBungee = this.getConfigE().getBoolean("Misc.UseBungeeCord", false);
        boolean spigotUsesBungee = Utils.detectBungeeCord();
        boolean bl = shareableDB = this.getDatabaseType().equals("mysql") || this.getDatabaseType().equals("global");
        if (useBungee && !spigotUsesBungee) {
            this.getLogger().warning("You have BungeeCord enabled for the plugin, but it looks like you have not enabled it in your spigot.yml! You probably should check your configuration.");
        } else if (!useBungee && spigotUsesBungee && shareableDB) {
            this.getLogger().warning("Your server is running behind a BungeeCord server. If you are using the plugin on more than one server with a shared database, please make sure to also enable the 'UseBungeeCord' config option.");
        } else if (useBungee && !shareableDB) {
            this.getLogger().info("You have enabled BungeeCord mode for the plugin, but are not using a shared MySQL database.");
            return false;
        }
        return useBungee;
    }

    public String getServerName() {
        return this.getConfigE().getString(KEY_SERVER_NAME, null);
    }

    public void setServerName(String serverName) {
        try {
            this.getConfigE().set(KEY_SERVER_NAME, (Object)serverName);
            this.save();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to set server name in config!", e);
        }
    }

    private void trySave() {
        try {
            this.save();
        }
        catch (FileNotFoundException e) {
            this.getLogger().log(Level.SEVERE, "Failed to save config!", e);
        }
    }
}

