/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SurnameCommand
extends MarryCommand {
    private final String helpSurnameParam;
    private final String helpPriestParam;
    private final String helpMMParam;
    private final String descSelf;

    public SurnameCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "surname", plugin.getLanguage().getTranslated("Commands.Description.Surname"), "marry.changesurname", plugin.getLanguage().getCommandAliases("Surname"));
        this.descSelf = plugin.getLanguage().getTranslated("Commands.Description.SurnameSelf");
        this.helpSurnameParam = "<" + plugin.getLanguage().getTranslated("Commands.SurnameVariable") + ">";
        this.helpMMParam = "<" + CommonMessages.getHelpPartnerNameVariable() + "> " + this.helpSurnameParam;
        this.helpPriestParam = plugin.areMultiplePartnersAllowed() ? "<" + CommonMessages.getHelpPlayerNameVariable() + "> <" + CommonMessages.getHelpPlayerNameVariable() + "> " + this.helpSurnameParam : "<" + CommonMessages.getHelpPlayerNameVariable() + "> " + this.helpSurnameParam;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player;
        if (args.length == 0) {
            this.showHelp(sender, mainCommandAlias);
            return;
        }
        String newSurname = args[args.length - 1];
        MarriagePlayer marriagePlayer = player = sender instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender) : null;
        if (player == null || player.isPriest() || this.getMarriagePlugin().isSelfMarriageAllowed() && sender.hasPermission("marry.selfmarry") && player.isMarried()) {
            if (args.length == 1 && this.getMarriagePlugin().isSelfMarriageAllowed() && player != null && sender.hasPermission("marry.selfmarry")) {
                if (player.getPartners().size() == 1) {
                    ((Marriage)player.getMarriageData()).setSurname(newSurname, player);
                } else {
                    CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
                }
            } else if (args.length == 2) {
                MarriagePlayer player2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                if (player == null || player.isPriest()) {
                    if (!player2.isOnline()) {
                        CommonMessages.getMessagePlayerNotOnline().send(sender, new Object[]{args[0]});
                    } else if (!player2.isMarried()) {
                        CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{args[0]});
                    } else if (player2.getMultiMarriageData().size() > 1) {
                        if (player != null && player.isPartner(player2)) {
                            ((Marriage)player.getMarriageData(player2)).setSurname(newSurname, player);
                        } else {
                            CommonMessages.getMessageMarriageNotExact().send(sender, new Object[0]);
                        }
                    } else {
                        ((Marriage)player2.getMarriageData()).setSurname(newSurname, sender);
                    }
                } else if (this.getMarriagePlugin().isSelfMarriageAllowed() && sender.hasPermission("marry.selfmarry")) {
                    if (player.isMarried()) {
                        if (player.isPartner(player2)) {
                            ((Marriage)player.getMarriageData(player2)).setSurname(newSurname, player);
                        } else {
                            CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                        }
                    } else {
                        CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
                    }
                } else {
                    this.showHelp(sender, mainCommandAlias);
                }
            } else if (args.length == 3 && this.getMarriagePlugin().areMultiplePartnersAllowed() && (player == null || player.isPriest())) {
                MarriagePlayer player1 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                MarriagePlayer player2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[1]);
                if (!player1.isMarried()) {
                    CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{player1.getName()});
                } else if (!player2.isMarried()) {
                    CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{player2.getName()});
                } else if (!player1.isPartner(player2)) {
                    CommonMessages.getMessagePlayersNotMarried().send(sender, new Object[0]);
                } else {
                    ((Marriage)player1.getMarriageData(player2)).setSurname(newSurname, sender);
                }
            } else {
                this.showHelp(sender, mainCommandAlias);
            }
        } else {
            CommonMessages.getMessageNoPermission().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1 || this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2) {
            MarriagePlayer player;
            MarriagePlayer marriagePlayer = player = sender instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender) : null;
            if (player == null || player.isPriest()) {
                return Utils.getPlayerNamesStartingWithVisibleOnly((String)args[args.length - 1], (CommandSender)sender, (String)"marry.bypass.vanish");
            }
            if (player.getPartners().size() > 1) {
                return player.getMatchingPartnerNames(args[args.length - 1]);
            }
        }
        return null;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        MarriagePlayer player;
        ArrayList<HelpData> help = new ArrayList<HelpData>(2);
        MarriagePlayer marriagePlayer = player = requester instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester) : null;
        if (player != null && player.isMarried() && this.getMarriagePlugin().isSelfMarriageAllowed() && requester.hasPermission("marry.selfmarry")) {
            if (player.getPartners().size() > 1) {
                help.add(new HelpData(this.getTranslatedName(), this.helpMMParam, this.descSelf));
            } else {
                help.add(new HelpData(this.getTranslatedName(), this.helpSurnameParam, this.descSelf));
            }
        }
        if (player == null || player.isPriest()) {
            help.add(new HelpData(this.getTranslatedName(), this.helpPriestParam, this.getDescription()));
        }
        return help;
    }
}

