/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriageData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Message.MessageColor;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class SetColorCommand
extends MarryCommand {
    private final Message messageUnknownColor;
    private final Message messageColorSet;
    private final Message messageColorSelection;

    public SetColorCommand(@NotNull MarriageMaster plugin) {
        super((JavaPlugin)plugin, "setcolor", plugin.getLanguage().getTranslated("Commands.Description.SetColor"), "marry.setcolor", true, true, plugin.getLanguage().getCommandAliases("SetColor"));
        this.messageUnknownColor = (Message)plugin.getLanguage().getMessage("Ingame.SetColor.UnknownColor").placeholder("Input");
        this.messageColorSet = plugin.getLanguage().getMessage("Ingame.SetColor.Set");
        this.messageColorSelection = (Message)((Message)plugin.getLanguage().getMessage("Ingame.SetColor.Selection").placeholder("MainCmdAlias")).placeholder("SubCmdAlias");
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        String colorArg;
        MessageColor color;
        Marriage marriage;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (args.length < 1) {
            if (player.getPartners().size() > 1) {
                this.showHelp(sender, mainCommandAlias);
            } else {
                this.messageColorSelection.send(sender, new Object[]{mainCommandAlias, alias});
            }
            return;
        }
        if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2) {
            marriage = (Marriage)player.getMarriageData(this.getMarriagePlugin().getPlayerData(args[0]));
            if (marriage == null) {
                CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                return;
            }
        } else {
            marriage = player.getNearestPartnerMarriageData();
        }
        if ((color = MessageColor.getColor((String)(colorArg = args[args.length - 1]))) == null) {
            this.messageUnknownColor.send(sender, new Object[]{colorArg});
        } else {
            ((MarriageData)marriage).setColor(color);
            this.messageColorSet.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (args.length != 1 && args.length != 2) {
            return null;
        }
        List<String> complete = ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
        List colors = MessageColor.getNamesStartingWith((String)args[args.length - 1]);
        if (complete == null) {
            return colors;
        }
        complete.addAll(colors);
        return complete;
    }
}

