/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class RequestCancelCommand
extends MarryCommand {
    private final String param;
    private final Message messageNothingToCancel;

    public RequestCancelCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "cancel", plugin.getLanguage().getTranslated("Commands.Description.Cancel"), null, true, plugin.getLanguage().getCommandAliases("Cancel"));
        this.param = "<" + CommonMessages.getHelpPlayerNameVariable() + " / " + plugin.getCommandManager().getAllSwitchTranslation() + ">";
        this.messageNothingToCancel = plugin.getLanguage().getMessage("Ingame.Requests.NothingToCancel");
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (!player.getRequestsToCancel().isEmpty()) {
            if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isAllSwitch(args[0])) {
                for (AcceptPendingRequest request : player.getRequestsToCancel()) {
                    request.cancel(player);
                }
            } else if (player.getRequestsToCancel().size() > 1) {
                MarriagePlayer otherPlayer = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                for (AcceptPendingRequest request : player.getRequestsToCancel()) {
                    if (!((MarriagePlayer)request.getPlayerThatHasToAccept()).equals(otherPlayer)) continue;
                    request.cancel(player);
                }
            } else {
                player.getRequestsToCancel().get(0).cancel(player);
            }
        } else {
            this.messageNothingToCancel.send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (player.getRequestsToCancel().size() > 1) {
            ArrayList<String> tab = new ArrayList<String>(player.getRequestsToCancel().size());
            String arg = args[0].toLowerCase();
            for (AcceptPendingRequest request : player.getRequestsToCancel()) {
                if (!((MarriagePlayer)request.getPlayerThatHasToAccept()).getName().toLowerCase().startsWith(arg)) continue;
                tab.add(((MarriagePlayer)request.getPlayerThatHasToAccept()).getName());
            }
            return tab;
        }
        return EMPTY_TAB_COMPLETE_LIST;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester);
        if (player.getRequestsToCancel().size() == 1) {
            super.getHelp(requester);
        } else if (player.getRequestsToCancel().size() > 1) {
            ArrayList<HelpData> help = new ArrayList<HelpData>(1);
            help.add(new HelpData(this.getTranslatedName(), this.param, this.getDescription()));
            return help;
        }
        return EMPTY_HELP_LIST;
    }
}

