/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PvPCommand
extends MarryCommand
implements Listener {
    private final Message messagePvPOn;
    private final Message messagePvPOff;
    private final Message messagePvPIsOff;
    private final String helpMulti;
    private final String helpOn;
    private final String helpOff;
    private MarryCommand onCommand;
    private MarryCommand offCommand;

    public PvPCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "pvp", plugin.getLanguage().getTranslated("Commands.Description.PvP"), "marry.pvp", true, true, plugin.getLanguage().getCommandAliases("PvP"));
        this.messagePvPOn = plugin.getLanguage().getMessage("Ingame.PvP.On");
        this.messagePvPOff = plugin.getLanguage().getMessage("Ingame.PvP.Off");
        this.messagePvPIsOff = plugin.getLanguage().getMessage("Ingame.PvP.IsDisabled");
        this.helpMulti = "<" + CommonMessages.getHelpPartnerNameVariable() + "> <" + plugin.getCommandManager().getOnSwitchTranslation() + " / " + plugin.getCommandManager().getOffSwitchTranslation() + " / " + plugin.getCommandManager().getToggleSwitchTranslation() + ">";
        this.helpOn = plugin.getCommandManager().getOnSwitchTranslation();
        this.helpOff = plugin.getCommandManager().getOffSwitchTranslation();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void afterRegister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        this.onCommand = new PvPOnCommand(plugin);
        plugin.getCommandManager().registerSubCommand(this.onCommand);
        this.offCommand = new PvPOffCommand(plugin);
        plugin.getCommandManager().registerSubCommand(this.offCommand);
    }

    public void beforeUnregister() {
        MarriageMaster plugin = (MarriageMaster)this.getMarriagePlugin();
        plugin.getCommandManager().unRegisterSubCommand(this.onCommand);
        this.onCommand.close();
        plugin.getCommandManager().unRegisterSubCommand(this.offCommand);
        this.offCommand.close();
    }

    @Override
    public void close() {
        if (this.onCommand != null) {
            this.onCommand.close();
            this.onCommand = null;
        }
        if (this.offCommand != null) {
            this.offCommand.close();
            this.offCommand = null;
        }
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        Marriage marriage;
        if (args.length < 1) {
            this.showHelp(sender, mainCommandAlias);
            return;
        }
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 2) {
            marriage = (Marriage)player.getMarriageData(this.getMarriagePlugin().getPlayerData(args[0]));
            if (marriage == null) {
                CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                return;
            }
        } else {
            marriage = player.getNearestPartnerMarriageData();
        }
        if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOnSwitch(args[args.length - 1])) {
            marriage.setPVPEnabled(true);
            this.messagePvPOn.send(sender, new Object[0]);
        } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isOffSwitch(args[args.length - 1])) {
            marriage.setPVPEnabled(false);
            this.messagePvPOff.send(sender, new Object[0]);
        } else if (((CommandManager)this.getMarriagePlugin().getCommandManager()).isToggleSwitch(args[args.length - 1])) {
            if (marriage.isPVPEnabled()) {
                marriage.setPVPEnabled(false);
                this.messagePvPOff.send(sender, new Object[0]);
            } else {
                marriage.setPVPEnabled(true);
                this.messagePvPOn.send(sender, new Object[0]);
            }
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester);
        if (player.isMarried()) {
            LinkedList<HelpData> help = new LinkedList<HelpData>();
            if (player.getPartners().size() > 1) {
                help.add(new HelpData(this.getTranslatedName(), this.helpMulti, this.getDescription()));
            } else {
                boolean isPVPEnabled = ((Marriage)player.getMarriageData()).isPVPEnabled();
                help.add(new HelpData(this.getTranslatedName() + (isPVPEnabled ? this.helpOff : this.helpOn), "", (isPVPEnabled ? this.offCommand : this.onCommand).getDescription()));
            }
            return help;
        }
        return EMPTY_HELP_LIST;
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (event.getEntity() instanceof Player) {
            Player dmgSource;
            if (event.getDamager() instanceof Player) {
                dmgSource = (Player)event.getDamager();
            } else if (event.getDamager() instanceof Projectile && ((Projectile)event.getDamager()).getShooter() instanceof Player) {
                dmgSource = (Player)((Projectile)event.getDamager()).getShooter();
            } else {
                return;
            }
            MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(dmgSource);
            Marriage marriage = (Marriage)player.getMarriageData(this.getMarriagePlugin().getPlayerData((Player)event.getEntity()));
            if (marriage != null && !marriage.isPVPEnabled()) {
                this.messagePvPIsOff.send((CommandSender)dmgSource, new Object[0]);
                event.setCancelled(true);
            }
        }
    }

    private class PvPOffCommand
    extends PvPSubCommand {
        public PvPOffCommand(MarriageMaster plugin) {
            super((JavaPlugin)plugin, "pvpoff", plugin.getLanguage().getTranslated("Commands.Description.PvPOff"), "marry.pvp", true, true, plugin.getLanguage().getCommandAliases("PvPOff"));
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            Marriage marriage = this.getMarriage((Player)sender, args);
            if (marriage != null) {
                marriage.setPVPEnabled(false);
                PvPCommand.this.messagePvPOff.send(sender, new Object[0]);
            }
        }
    }

    private class PvPOnCommand
    extends PvPSubCommand {
        public PvPOnCommand(MarriageMaster plugin) {
            super((JavaPlugin)plugin, "pvpon", plugin.getLanguage().getTranslated("Commands.Description.PvPOn"), "marry.pvp", true, true, plugin.getLanguage().getCommandAliases("PvPOn"));
        }

        @Override
        public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            Marriage marriage = this.getMarriage((Player)sender, args);
            if (marriage != null) {
                marriage.setPVPEnabled(true);
                PvPCommand.this.messagePvPOn.send(sender, new Object[0]);
            }
        }
    }

    private static abstract class PvPSubCommand
    extends MarryCommand {
        public PvPSubCommand(JavaPlugin plugin, String name, String description, String permission, boolean mustBeMarried, boolean partnerSelectorInHelpForMoreThanOnePartner, String ... aliases) {
            super(plugin, name, description, permission, mustBeMarried, partnerSelectorInHelpForMoreThanOnePartner, aliases);
        }

        @Override
        public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
            return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
        }

        @Override
        public List<HelpData> getHelp(@NotNull CommandSender requester) {
            return EMPTY_HELP_LIST;
        }

        protected Marriage getMarriage(Player sender, String[] args) {
            Marriage marriage;
            MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(sender);
            if (this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length == 1) {
                marriage = (Marriage)player.getMarriageData(this.getMarriagePlugin().getPlayerData(args[0]));
                if (marriage == null) {
                    CommonMessages.getMessageTargetPartnerNotFound().send((CommandSender)sender, new Object[0]);
                    return null;
                }
            } else {
                marriage = player.getNearestPartnerMarriageData();
            }
            return marriage;
        }
    }
}

