/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Bukkit.Message.Sender.SendMethod;
import at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Placeholder.Placeholders;
import at.pcgamingfreaks.Message.MessageComponent;
import at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.PassthroughMessageComponentPlaceholderProcessor;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class PartnersCommand
extends MarryCommand {
    private final Message messageHeadlineMain;
    private final Message messageFooter;
    private final Message messageListFormat;
    private final Message messageNotMarried;

    public PartnersCommand(@NotNull MarriageMaster plugin) {
        super((JavaPlugin)plugin, "partners", plugin.getLanguage().getTranslated("Commands.Description.Partners"), "marry.partners", plugin.getLanguage().getCommandAliases("Partners"));
        this.messageListFormat = (Message)((Message)((Message)((Message)((Message)((Message)plugin.getLanguage().getMessage("Ingame.Partners.Format").placeholder("Player1Name")).placeholder("Player2Name")).placeholder("Player1DisplayName", (IPlaceholderProcessor)PassthroughMessageComponentPlaceholderProcessor.INSTANCE)).placeholder("Player2DisplayName", (IPlaceholderProcessor)PassthroughMessageComponentPlaceholderProcessor.INSTANCE)).placeholder("Surname")).placeholder("MagicHeart");
        this.messageHeadlineMain = (Message)plugin.getLanguage().getMessage("Ingame.Partners.Headline").placeholders(Placeholders.PLAYER_NAME);
        this.messageFooter = (Message)plugin.getLanguage().getMessage("Ingame.Partners.Footer").placeholders(Placeholders.PLAYER_NAME);
        this.messageNotMarried = (Message)plugin.getLanguage().getMessage("Ingame.Partners.NotMarried").placeholders(Placeholders.PLAYER_NAME);
        if (!plugin.getConfiguration().useListFooter()) {
            this.messageFooter.setSendMethod(SendMethod.DISABLED);
        }
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer filterPlayer;
        boolean self = false;
        if (args.length > 0 && sender.hasPermission("marry.partners.others")) {
            filterPlayer = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
        } else if (sender instanceof Player) {
            filterPlayer = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
            self = true;
        } else {
            this.showHelp(sender, mainCommandAlias);
            return;
        }
        if (filterPlayer.isMarried()) {
            this.messageHeadlineMain.send(sender, new Object[]{filterPlayer});
            for (Marriage couple : filterPlayer.getMultiMarriageData()) {
                MarriagePlayer partner = (MarriagePlayer)couple.getPartner(filterPlayer);
                if (partner == null) continue;
                MessageComponent p1DName = ((MarriagePlayerData)filterPlayer).getDisplayNameMessageComponentCheckVanished(sender);
                MessageComponent p2DName = ((MarriagePlayerData)partner).getDisplayNameMessageComponentCheckVanished(sender);
                this.messageListFormat.send(sender, new Object[]{filterPlayer.getName(), partner.getName(), p1DName, p2DName, couple.getSurnameString(), couple.getMagicHeart()});
            }
            this.messageFooter.send(sender, new Object[]{filterPlayer});
        } else if (self) {
            CommonMessages.getMessageNotMarried().send(sender, new Object[0]);
        } else {
            this.messageNotMarried.send(sender, new Object[]{filterPlayer});
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        if (sender.hasPermission("marry.partners.others") && args.length == 1) {
            return Utils.getPlayerNamesStartingWithVisibleOnly((String)args[0], (CommandSender)sender, (String)"marry.bypass.vanish");
        }
        return EMPTY_TAB_COMPLETE_LIST;
    }
}

