/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Util.Utils;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MarryDivorceCommand
extends MarryCommand {
    private final String descriptionSelf;
    private final String helpParam;
    private final String helpPriest;

    public MarryDivorceCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "divorce", plugin.getLanguage().getTranslated("Commands.Description.Divorce"), plugin.getLanguage().getCommandAliases("Divorce"));
        this.descriptionSelf = plugin.getLanguage().getTranslated("Commands.Description.DivorceSelf");
        this.helpParam = "<" + CommonMessages.getHelpPartnerNameVariable() + ">";
        this.helpPriest = plugin.areMultiplePartnersAllowed() ? this.helpParam + " " + this.helpParam : this.helpParam;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer player;
        MarriagePlayer marriagePlayer = player = sender instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender) : null;
        if (player == null || player.isPriest() || this.getMarriagePlugin().isSelfDivorceAllowed() && player.isMarried() && sender.hasPermission("marry.selfdivorce")) {
            if ((player == null || player.isPriest()) && (this.getMarriagePlugin().areMultiplePartnersAllowed() ? args.length == 2 : args.length == 1)) {
                MarriagePlayer p1 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                if (args.length == 1) {
                    Marriage marriage = (Marriage)p1.getMarriageData();
                    if (marriage == null) {
                        CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{args[0]});
                    } else if (player != null) {
                        this.getMarriagePlugin().getMarriageManager().divorce(marriage, player, p1);
                    } else {
                        this.getMarriagePlugin().getMarriageManager().divorce(marriage, sender);
                    }
                } else {
                    MarriagePlayer p2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[1]);
                    if (!p1.isMarried()) {
                        CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{args[0]});
                    } else if (!p2.isMarried()) {
                        CommonMessages.getMessagePlayerNotMarried().send(sender, new Object[]{args[1]});
                    } else if (p1.isPartner(p2)) {
                        if (player != null) {
                            this.getMarriagePlugin().getMarriageManager().divorce(p1.getMarriageData(p2), player, p1);
                        } else {
                            this.getMarriagePlugin().getMarriageManager().divorce(p1.getMarriageData(p2), sender);
                        }
                    } else {
                        CommonMessages.getMessagePlayersNotMarried().send(sender, new Object[0]);
                    }
                }
            } else if (player != null && this.getMarriagePlugin().isSelfDivorceAllowed() && player.isMarried() && sender.hasPermission("marry.selfdivorce") && (this.getMarriagePlugin().areMultiplePartnersAllowed() ? args.length == 1 || player.getPartners().size() == 1 && args.length == 0 : args.length == 0)) {
                Marriage marriage;
                if (args.length == 1) {
                    MarriagePlayer player2 = (MarriagePlayer)player.getPartner(args[0]);
                    if (player2 == null) {
                        CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
                        return;
                    }
                    marriage = (Marriage)player.getMarriageData(player2);
                } else {
                    marriage = (Marriage)player.getMarriageData();
                }
                marriage.divorce(player);
            } else {
                this.showHelp(sender, mainCommandAlias);
            }
        } else {
            CommonMessages.getMessageNoPermission().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer marriagePlayerData;
        if (args.length == 0 || !this.canUse(sender)) {
            return EMPTY_TAB_COMPLETE_LIST;
        }
        List<String> names = null;
        MarriagePlayer marriagePlayer = marriagePlayerData = sender instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender) : null;
        if (marriagePlayerData == null || marriagePlayerData.isPriest()) {
            if (args.length == 1) {
                names = Utils.getPlayerNamesStartingWithVisibleOnly((String)args[0], (CommandSender)sender, (String)"marry.bypass.vanish");
            } else if (args.length == 2) {
                MarriagePlayer player1 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(args[0]);
                names = player1.getMatchingPartnerNames(args[1]);
            }
        } else if (this.getMarriagePlugin().isSelfDivorceAllowed() && marriagePlayerData.isMarried() && sender.hasPermission("marry.selfdivorce")) {
            names = marriagePlayerData.getMatchingPartnerNames(args[args.length - 1]);
        }
        return names;
    }

    @Override
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        MarriagePlayer player;
        ArrayList<HelpData> help = new ArrayList<HelpData>(2);
        MarriagePlayer marriagePlayer = player = requester instanceof Player ? (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester) : null;
        if (player != null && this.getMarriagePlugin().isSelfDivorceAllowed() && player.isMarried() && (requester.hasPermission("marry.selfmarry") || requester.hasPermission("marry.selfdivorce"))) {
            if (player.getPartners().size() > 1) {
                help.add(new HelpData(this.getTranslatedName(), this.helpParam, this.descriptionSelf));
            } else {
                help.add(new HelpData(this.getTranslatedName(), "", this.descriptionSelf));
            }
        }
        if (player == null || player.isPriest()) {
            help.add(new HelpData(this.getTranslatedName(), this.helpPriest, this.getDescription()));
        }
        return help;
    }
}

