/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.MCVersion;
import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Bukkit.Particles.Particle;
import at.pcgamingfreaks.Bukkit.Particles.ParticleSpawner;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Events.KissEvent;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.Marriage;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Range;
import at.pcgamingfreaks.Message.Placeholder.Processors.FloatPlaceholderProcessor;
import at.pcgamingfreaks.Message.Placeholder.Processors.IPlaceholderProcessor;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class KissCommand
extends MarryCommand
implements Listener {
    private static KissCommand instance;
    private final Message messageKissed;
    private final Message messageGotKissed;
    private final Message messageTooFarAway;
    private final Message messageWait;
    private final double interactRange;
    private final double range;
    private final double rangeSquared;
    private final double hearthVisibleRange;
    private final int waitTime;
    private final int hearthCount;
    private ParticleSpawner particleSpawner = ParticleSpawner.getParticleSpawner();

    public KissCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "kiss", plugin.getLanguage().getTranslated("Commands.Description.Kiss"), "marry.kiss", true, false, plugin.getLanguage().getCommandAliases("Kiss"));
        this.range = plugin.getConfiguration().getRange(Range.Kiss);
        this.rangeSquared = plugin.getConfiguration().getRangeSquared(Range.Kiss);
        this.interactRange = plugin.getConfiguration().getRangeSquared(Range.KissInteract);
        this.hearthVisibleRange = plugin.getConfiguration().getRange(Range.HearthVisible);
        this.waitTime = plugin.getConfiguration().getKissWaitTime();
        this.hearthCount = plugin.getConfiguration().getKissHearthCount();
        this.messageKissed = plugin.getLanguage().getMessage("Ingame.Kiss.Kissed");
        this.messageGotKissed = plugin.getLanguage().getMessage("Ingame.Kiss.GotKissed");
        FloatPlaceholderProcessor singleDecimalPointProcessor = new FloatPlaceholderProcessor(1);
        this.messageTooFarAway = (Message)plugin.getLanguage().getMessage("Ingame.Kiss.TooFarAway").placeholder("Distance", (IPlaceholderProcessor)singleDecimalPointProcessor);
        this.messageWait = (Message)((Message)plugin.getLanguage().getMessage("Ingame.Kiss.Wait").placeholder("Time")).placeholder("TimeLeft", (IPlaceholderProcessor)singleDecimalPointProcessor);
        if (plugin.getConfiguration().isKissInteractEnabled()) {
            plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
        KissCommand.setInstance(this);
    }

    @Override
    public void close() {
        HandlerList.unregisterAll((Listener)this);
        KissCommand.setInstance(null);
        this.particleSpawner = null;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer partner;
        MarriagePlayer player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        MarriagePlayer marriagePlayer = partner = this.getMarriagePlugin().areMultiplePartnersAllowed() && args.length >= 1 ? (MarriagePlayer)player.getPartner(args[0]) : (MarriagePlayer)player.getNearestPartnerMarriageData().getPartner(player);
        if (partner == null) {
            CommonMessages.getMessageTargetPartnerNotFound().send(sender, new Object[0]);
        } else if (partner.isOnline() && partner.getPlayerOnline() != null) {
            if (this.getMarriagePlugin().isInRangeSquared((Player)sender, (Player)partner.getPlayerOnline(), this.rangeSquared)) {
                this.kiss(player, partner);
            } else {
                this.messageTooFarAway.send(sender, new Object[]{this.range});
            }
        } else {
            CommonMessages.getMessagePartnerOffline().send(sender, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return ((CommandManager)this.getMarriagePlugin().getCommandManager()).getSimpleTabComplete(sender, args);
    }

    private boolean canKissAgain(MarriagePlayer player) {
        return player.getLastKissTime() < System.currentTimeMillis() - (long)this.waitTime || player.hasPermission("marry.bypass.delay");
    }

    public void kiss(MarriagePlayer player, MarriagePlayer partner) {
        if (this.canKissAgain(player)) {
            KissEvent event = new KissEvent(player, (Marriage)player.getMarriageData(partner));
            Bukkit.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                player.setLastKissTime(System.currentTimeMillis());
                player.send(this.messageKissed, new Object[0]);
                partner.send(this.messageGotKissed, new Object[0]);
                if (this.particleSpawner != null) {
                    this.particleSpawner.spawnParticle(((Player)player.getPlayerOnline()).getLocation(), Particle.HEART, this.hearthVisibleRange, this.hearthCount, 1.0f, 1.0f, 1.0f, 1.0f);
                    this.particleSpawner.spawnParticle(((Player)partner.getPlayerOnline()).getLocation(), Particle.HEART, this.hearthVisibleRange, this.hearthCount, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        } else {
            player.send(this.messageWait, this.waitTime / 1000, (double)(player.getLastKissTime() - System.currentTimeMillis() + (long)this.waitTime) / 1000.0);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        MarriagePlayer player2;
        MarriagePlayer player;
        if ((!MCVersion.isDualWieldingMC() || event.getHand().equals((Object)EquipmentSlot.HAND)) && event.getPlayer().isSneaking() && event.getPlayer().hasPermission("marry.kiss") && event.getRightClicked() instanceof Player && this.canKissAgain(player = (MarriagePlayer)this.getMarriagePlugin().getPlayerData(event.getPlayer())) && player.isPartner(player2 = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)event.getRightClicked())) && this.getMarriagePlugin().isInRangeSquared(event.getPlayer(), (Player)event.getRightClicked(), this.interactRange)) {
            this.kiss(player, player2);
        }
    }

    public static KissCommand getInstance() {
        return instance;
    }

    private static void setInstance(KissCommand instance) {
        KissCommand.instance = instance;
    }
}

