/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Message.MessageColor;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHelpCommand
extends MarryCommand {
    private final List<Message> messagesDefault;
    private final List<Message> messagesMarried;
    private final List<Message> messagesPriest;

    public CustomHelpCommand(MarriageMaster plugin) {
        super((JavaPlugin)plugin, "!!!custom_help!!!", "", null, true, new String[0]);
        this.messagesDefault = CustomHelpCommand.getMessages(plugin, "Default");
        this.messagesMarried = CustomHelpCommand.getMessages(plugin, "Married");
        this.messagesPriest = CustomHelpCommand.getMessages(plugin, "Priest");
    }

    private static List<Message> getMessages(@NotNull MarriageMaster plugin, @NotNull String type) {
        List stringMessages = plugin.getLanguage().getLangE().getStringList("Language.Ingame.Help.CustomHelp." + type, new ArrayList(0));
        ArrayList<Message> messages = new ArrayList<Message>(stringMessages.size());
        for (String message : stringMessages) {
            messages.add(new Message(MessageColor.translateAlternateColorAndFormatCodes((String)message)));
        }
        return messages;
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        MarriagePlayer marriagePlayer = (MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender);
        Player player = (Player)sender;
        List<Message> messages = marriagePlayer.isMarried() ? this.messagesMarried : (marriagePlayer.isPriest() ? this.messagesPriest : this.messagesDefault);
        for (Message msg : messages) {
            msg.send((CommandSender)player, new Object[0]);
        }
    }

    @Override
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, @NotNull String[] args) {
        return EMPTY_TAB_COMPLETE_LIST;
    }

    @Override
    @Nullable
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        return EMPTY_HELP_LIST;
    }
}

