/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.Commands;

import at.pcgamingfreaks.Bukkit.Command.CommandExecutorWithSubCommandsGeneric;
import at.pcgamingfreaks.Bukkit.Command.RegisterablePluginCommand;
import at.pcgamingfreaks.Bukkit.Command.SubCommand;
import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.API.AcceptPendingRequest;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.CommandManager;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.BackpackCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.ChatCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.CustomHelpCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.DebugCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.GiftCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.HelpCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.HomeCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.HugCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.KissCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.ListCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.ListPriestsCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.MarryDivorceCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.MarryMarryCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.PartnersCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.PvPCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.ReloadCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.RequestAcceptCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.RequestCancelCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.RequestDenyCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.SeenCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.SetColorCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.SetPriestCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.SurnameCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.TpCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.UpdateCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Commands.VersionCommand;
import at.pcgamingfreaks.MarriageMaster.Bukkit.CommonMessages;
import at.pcgamingfreaks.MarriageMaster.Bukkit.Database.MarriagePlayerData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandManagerImplementation
extends CommandExecutorWithSubCommandsGeneric<MarryCommand>
implements CommandManager {
    private final MarriageMaster plugin;
    private String[] switchesOn;
    private String[] switchesOff;
    private String[] switchesToggle;
    private String[] switchesAll;
    private String[] switchesRemove;
    private RegisterablePluginCommand marryCommand;
    private MarryCommand marryActionCommand;
    private Message helpFormat;

    public CommandManagerImplementation(MarriageMaster plugin) {
        this.plugin = plugin;
    }

    public void init() {
        this.switchesOn = this.plugin.getLanguage().getSwitch("On", "on");
        this.switchesOff = this.plugin.getLanguage().getSwitch("Off", "off");
        this.switchesToggle = this.plugin.getLanguage().getSwitch("Toggle", "toggle");
        this.switchesAll = this.plugin.getLanguage().getSwitch("All", "all");
        this.switchesRemove = this.plugin.getLanguage().getSwitch("Remove", "remove");
        this.marryCommand = new RegisterablePluginCommand((Plugin)this.plugin, "marry", this.plugin.getLanguage().getCommandAliases("Main"));
        this.marryCommand.registerCommand();
        this.marryCommand.setExecutor((CommandExecutor)this);
        this.marryCommand.setTabCompleter((TabCompleter)this);
        this.helpFormat = (Message)((Message)((Message)((Message)this.plugin.getLanguage().getMessage("Commands.HelpFormat").placeholder("MainCommand")).placeholder("SubCommand")).placeholder("Parameters")).placeholder("Description");
        try {
            Reflection.setStaticField(MarryCommand.class, (String)"marriagePlugin", (Object)this.plugin);
            Reflection.setStaticField(MarryCommand.class, (String)"showHelp", (Object)this.getClass().getDeclaredMethod("sendHelp", CommandSender.class, String.class, Collection.class));
            Reflection.setStaticField(MarryCommand.class, (String)"messageNoPermission", (Object)CommonMessages.getMessageNoPermission());
            Reflection.setStaticField(MarryCommand.class, (String)"messageNotFromConsole", (Object)CommonMessages.getMessageNotFromConsole());
            Reflection.setStaticField(MarryCommand.class, (String)"messageNotMarried", (Object)CommonMessages.getMessageNotMarried());
            Reflection.setStaticField(MarryCommand.class, (String)"helpPartnerSelector", (Object)("<" + CommonMessages.getHelpPartnerNameVariable() + ">"));
            Reflection.setStaticField(AcceptPendingRequest.class, (String)"closeMethod", (Object)MarriagePlayerData.class.getMethod("closeRequest", at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest.class));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, ConsoleColor.RED + "Unable to set the help format. Default format will be used." + ConsoleColor.RESET, e);
        }
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new ListCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new ListPriestsCommand(this.plugin));
        if (this.plugin.areMultiplePartnersAllowed()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new PartnersCommand(this.plugin));
        }
        this.marryActionCommand = new MarryMarryCommand(this.plugin);
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)this.marryActionCommand);
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new MarryDivorceCommand(this.plugin));
        if (this.plugin.getConfiguration().isChatEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new ChatCommand(this.plugin));
        }
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new TpCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new HomeCommand(this.plugin));
        if (this.plugin.getConfiguration().getPvPAllowBlocking()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new PvPCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isGiftEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new GiftCommand(this.plugin));
        }
        if (this.plugin.getBackpacksIntegration() != null && this.plugin.getConfiguration().isBackpackShareEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new BackpackCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isKissEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new KissCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isHugEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new HugCommand(this.plugin));
        }
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new SeenCommand(this.plugin));
        if (this.plugin.getConfiguration().isAllowPlayersToChangeMarriageColor()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new SetColorCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isSurnamesEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new SurnameCommand(this.plugin));
        }
        if (this.plugin.getConfiguration().isSetPriestCommandEnabled()) {
            this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new SetPriestCommand(this.plugin));
        }
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new UpdateCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new ReloadCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new VersionCommand(this.plugin));
        HelpCommand helpCommand = new HelpCommand(this.plugin, this.commands);
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)helpCommand);
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new RequestAcceptCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new RequestDenyCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new RequestCancelCommand(this.plugin));
        this.registerSubCommand((at.pcgamingfreaks.Command.SubCommand)new DebugCommand(this.plugin));
        switch (this.plugin.getConfiguration().getDefaultCommand()) {
            case "customhelp": 
            case "custom_help": {
                this.setDefaultSubCommand((at.pcgamingfreaks.Command.SubCommand)new CustomHelpCommand(this.plugin));
                break;
            }
            default: {
                this.setDefaultSubCommand((at.pcgamingfreaks.Command.SubCommand)helpCommand);
            }
        }
    }

    public void close() {
        this.marryCommand.unregisterCommand();
        super.close();
    }

    public void sendHelp(CommandSender target, String marryAlias, Collection<HelpData> data) {
        for (HelpData d : data) {
            this.helpFormat.send(target, new Object[]{marryAlias, d.getTranslatedSubCommand(), d.getParameter(), d.getDescription()});
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length > 0) {
            SubCommand subCommand = (SubCommand)this.subCommandMap.get(args[0].toLowerCase(Locale.ENGLISH));
            if (subCommand != null) {
                subCommand.doExecute((Object)sender, alias, args[0], args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
                return true;
            }
            Player target = this.plugin.getServer().getPlayer(args[0]);
            if (target != null && args.length <= 2) {
                this.marryActionCommand.doExecute(sender, alias, "marry", args);
                return true;
            }
        }
        ((MarryCommand)this.defaultSubCommand).doExecute(sender, alias, "help", args);
        return true;
    }

    @Override
    public boolean isOnSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesOn, (String)str);
    }

    @Override
    public boolean isOffSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesOff, (String)str);
    }

    @Override
    public boolean isToggleSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesToggle, (String)str);
    }

    @Override
    public boolean isAllSwitch(String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesAll, (String)str);
    }

    @Override
    public boolean isRemoveSwitch(@Nullable String str) {
        return StringUtils.arrayContainsIgnoreCase((String[])this.switchesRemove, (String)str);
    }

    @Override
    @NotNull
    public String getOnSwitchTranslation() {
        return this.switchesOn[0];
    }

    @Override
    @NotNull
    public String getOffSwitchTranslation() {
        return this.switchesOff[0];
    }

    @Override
    @NotNull
    public String getToggleSwitchTranslation() {
        return this.switchesToggle[0];
    }

    @Override
    @NotNull
    public String getAllSwitchTranslation() {
        return this.switchesAll[0];
    }

    @Override
    @NotNull
    public String getRemoveSwitchTranslation() {
        return this.switchesRemove[0];
    }

    @Override
    @Nullable
    public List<String> getSimpleTabComplete(@NotNull CommandSender sender, String ... args) {
        List<String> names = null;
        if (sender instanceof Player && this.plugin.areMultiplePartnersAllowed() && args != null && args.length == 1 && (names = this.plugin.getPlayerData((OfflinePlayer)((Player)sender)).getMatchingPartnerNames(args[0])).isEmpty()) {
            names = null;
        }
        return names;
    }

    @Override
    public boolean registerAcceptPendingRequest(@NotNull at.pcgamingfreaks.MarriageMaster.Bukkit.API.AcceptPendingRequest request) {
        if (((MarriagePlayer)request.getPlayerThatHasToAccept()).getOpenRequest() != null || !((MarriagePlayer)request.getPlayerThatHasToAccept()).isOnline() || !(request.getPlayerThatHasToAccept() instanceof MarriagePlayerData)) {
            return false;
        }
        for (MarriagePlayer p : (MarriagePlayer[])request.getPlayersThatCanCancel()) {
            if (p instanceof MarriagePlayerData && p.isOnline()) continue;
            return false;
        }
        for (MarriagePlayer p : (MarriagePlayer[])request.getPlayersThatCanCancel()) {
            ((MarriagePlayerData)p).addRequest(request);
        }
        ((MarriagePlayerData)request.getPlayerThatHasToAccept()).addRequest(request);
        if (!((MarriagePlayer)request.getPlayerThatHasToAccept()).hasPermission("marry.accept")) {
            request.deny(request.getPlayerThatHasToAccept());
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        List results = super.onTabComplete(sender, command, alias, args);
        if (results != null && (args.length == 1 && this.marryActionCommand.canUse(sender) || results.isEmpty() && args.length == 2 && (!(sender instanceof Player) || this.plugin.getPlayerData((OfflinePlayer)((Player)sender)).isPriest()))) {
            results.addAll(this.marryActionCommand.tabComplete(sender, alias, "marry", args));
        }
        return results;
    }
}

