/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit;

import java.lang.reflect.Field;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class BadRabbit
extends JavaPlugin {
    private JavaPlugin newPluginInstance = null;

    public void onLoad() {
        try {
            if (!(Bukkit.getPluginManager() instanceof SimplePluginManager)) {
                this.getLogger().warning("[BadRabbit] Unknown plugin manager detected! Disabling plugin.");
                return;
            }
            if (BadRabbit.detectPluginManager()) {
                this.getLogger().severe("[BadRabbit] Please do not load this plugin using PluginManager! It might cause problems or does not load correctly!");
            }
            Class<?> pluginClassLoader = Class.forName("org.bukkit.plugin.java.PluginClassLoader");
            Field fieldPluginClassLoaderPlugin = BadRabbit.getField(pluginClassLoader, "plugin");
            fieldPluginClassLoaderPlugin.set(this.getClassLoader(), null);
            BadRabbit.getField(pluginClassLoader, "pluginInit").set(this.getClassLoader(), null);
            this.newPluginInstance = this.createInstance();
            fieldPluginClassLoaderPlugin.set(this.getClassLoader(), this.newPluginInstance);
            this.replaceSelfInPluginList((Plugin)this.newPluginInstance);
            this.newPluginInstance.onLoad();
            if (BadRabbit.detectPlugMan()) {
                this.getLogger().warning("[BadRabbit] Please do not load this plugin using PlugMan! It might cause problems or does not load correctly!");
                BadRabbit.getField(JavaPlugin.class, "isEnabled").set((Object)this, true);
                Bukkit.getPluginManager().enablePlugin((Plugin)this.newPluginInstance);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "[BadRabbit] Failed switching to real plugin!", e);
        }
    }

    private void replaceSelfInPluginList(Plugin newPluginInstance) throws Exception {
        List plugins = (List)BadRabbit.getField(SimplePluginManager.class, "plugins").get(Bukkit.getPluginManager());
        int index = plugins.indexOf((Object)this);
        if (index == -1) {
            if (BadRabbit.detectPluginManager()) {
                plugins.add(newPluginInstance);
            }
        } else {
            plugins.set(index, newPluginInstance);
        }
        if (BadRabbit.detectPluginManager()) {
            int countCurrent = 0;
            int countNew = 0;
            ListIterator pluginsIterator = plugins.listIterator();
            while (pluginsIterator.hasNext()) {
                Plugin plugin = (Plugin)pluginsIterator.next();
                if (plugin.equals((Object)this)) {
                    ++countCurrent;
                    pluginsIterator.remove();
                    continue;
                }
                if (!plugin.equals(newPluginInstance) || ++countNew <= 1) continue;
                pluginsIterator.remove();
            }
            if (countNew < 1) {
                plugins.add(newPluginInstance);
            }
        }
        Map lookup = (Map)BadRabbit.getField(SimplePluginManager.class, "lookupNames").get(Bukkit.getPluginManager());
        lookup.replace(this.getDescription().getName(), this, newPluginInstance);
        lookup.replace(this.getDescription().getName().toLowerCase(Locale.ENGLISH), this, newPluginInstance);
        try {
            this.getDescription().getClass().getMethod("getProvides", new Class[0]);
            for (String provides : this.getDescription().getProvides()) {
                lookup.replace(provides, this, newPluginInstance);
                lookup.replace(provides.toLowerCase(Locale.ENGLISH), this, newPluginInstance);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private static boolean detectPlugMan() {
        return BadRabbit.doesCallstackContain("com.rylinaux.plugman");
    }

    private static boolean detectPluginManager() {
        return BadRabbit.doesCallstackContain("net.lenni0451.spm");
    }

    private static boolean doesCallstackContain(String searchFor) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new Throwable().getStackTrace()) {
            if (!stackTraceElement.getClassName().contains(searchFor)) continue;
            return true;
        }
        return false;
    }

    public void onEnable() {
        if (BadRabbit.detectPluginManager()) {
            this.getLogger().severe("[BadRabbit] Please do not load/enable this plugin using PluginManager! It might cause problems or does not load correctly!");
            try {
                this.replaceSelfInPluginList((Plugin)this.newPluginInstance);
                Bukkit.getPluginManager().enablePlugin((Plugin)this.newPluginInstance);
                this.getLogger().severe("[BadRabbit] Plugin enabled with PluginManager! API will most likely not be available!!!");
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "[BadRabbit] Failed to enable plugin!", e);
                this.setEnabled(false);
            }
        } else {
            this.getLogger().warning("[BadRabbit] Failed to enable plugin.");
            this.setEnabled(false);
        }
    }

    @NotNull
    protected static Field getField(@NotNull Class<?> clazz, @NotNull String name) throws Exception {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    @NotNull
    protected abstract JavaPlugin createInstance() throws Exception;
}

