/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration;

import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.BackpackPluginIncompatibleException;
import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.IBackpackIntegration;
import at.pcgamingfreaks.Minepacks.Bukkit.API.MinepacksPlugin;
import at.pcgamingfreaks.Version;
import java.util.MissingResourceException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class MinepacksV2Integration
implements IBackpackIntegration {
    private static final String PLUGIN_NAME = "Minepacks";
    private static final Version MIN_VERSION = new Version("2.0");
    private static final Version ITEM_FILTER_MIN_VERSION = new Version("2.3.8");
    private MinepacksPlugin minepacks;
    private final boolean supportsItemFilter;
    private final String version;

    public MinepacksV2Integration() throws NullPointerException, BackpackPluginIncompatibleException {
        Plugin bukkitPlugin = Bukkit.getPluginManager().getPlugin(PLUGIN_NAME);
        if (!(bukkitPlugin instanceof MinepacksPlugin)) {
            throw new MissingResourceException("Plugin Minepacks is not available!", this.getClass().getName(), PLUGIN_NAME);
        }
        this.version = bukkitPlugin.getDescription().getVersion();
        Version installedVersion = new Version(this.version, true);
        if (MIN_VERSION.newerThan(installedVersion)) {
            throw new BackpackPluginIncompatibleException("Your Minepacks version is outdated! Please update in order to use it with this plugin!\nYou have installed: " + installedVersion + " Required: " + MIN_VERSION);
        }
        this.supportsItemFilter = ITEM_FILTER_MIN_VERSION.olderThan(installedVersion);
        this.minepacks = (MinepacksPlugin)bukkitPlugin;
    }

    @Override
    public void openBackpack(@NotNull Player opener, @NotNull Player owner, boolean editable) {
        this.minepacks.openBackpack(opener, (OfflinePlayer)owner, editable);
    }

    @Override
    public void close() {
        this.minepacks = null;
    }

    @Override
    @NotNull
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean isBackpackItem(ItemStack item) {
        if (!this.supportsItemFilter) {
            return false;
        }
        return this.minepacks.isBackpackItem(item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

