/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration;

import at.pcgamingfreaks.ConsoleColor;
import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.BackpackPluginIncompatibleException;
import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.IBackpackIntegration;
import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.MinepacksV1Integration;
import at.pcgamingfreaks.MarriageMaster.Bukkit.BackpackIntegration.MinepacksV2Integration;
import at.pcgamingfreaks.MarriageMaster.Bukkit.MarriageMaster;
import at.pcgamingfreaks.Reflection;
import at.pcgamingfreaks.VersionRange;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BackpackIntegrationManager {
    private static IBackpackIntegration integration = null;
    private static final List<BackpackPluginMetadata> compatiblePlugins = new LinkedList<BackpackPluginMetadata>();

    private static void registerCompatiblePlugin(String identifier, VersionRange versionRange, Class<? extends IBackpackIntegration> integrationClass) {
        compatiblePlugins.add(new BackpackPluginMetadata(identifier, versionRange, integrationClass));
    }

    public static IBackpackIntegration getIntegration() {
        return integration;
    }

    public static void initIntegration() {
        for (BackpackPluginMetadata plugin : compatiblePlugins) {
            try {
                Plugin bukkitPlugin = Bukkit.getPluginManager().getPlugin(plugin.identifier);
                if (bukkitPlugin == null || !plugin.versionRange.inRange(bukkitPlugin.getDescription().getVersion()) || !bukkitPlugin.isEnabled()) continue;
                integration = (IBackpackIntegration)Reflection.getConstructor((Class)plugin.integrationClass, (Class[])new Class[0]).newInstance(new Object[0]);
                MarriageMaster.getInstance().getLogger().info(ConsoleColor.GREEN + "Successful linked with " + ConsoleColor.YELLOW + plugin.identifier + " v" + bukkitPlugin.getDescription().getVersion() + ConsoleColor.GREEN + "!" + ConsoleColor.RESET);
                return;
            }
            catch (Throwable t) {
                if (!(t.getCause() instanceof BackpackPluginIncompatibleException)) continue;
                MarriageMaster.getInstance().getLogger().warning(ConsoleColor.RED + " " + t.getCause().getMessage() + ConsoleColor.RESET);
            }
        }
        MarriageMaster.getInstance().getLogger().info("No compatible backpack plugin found.");
    }

    private BackpackIntegrationManager() {
    }

    static {
        BackpackIntegrationManager.registerCompatiblePlugin("MinePacks", new VersionRange("1.17.7", "1.999"), MinepacksV1Integration.class);
        BackpackIntegrationManager.registerCompatiblePlugin("Minepacks", new VersionRange("2.0-SNAPSHOT", "2.999"), MinepacksV2Integration.class);
    }

    private static final class BackpackPluginMetadata {
        private final String identifier;
        private final VersionRange versionRange;
        private final Class<? extends IBackpackIntegration> integrationClass;

        private BackpackPluginMetadata(String identifier, VersionRange versionRange, Class<? extends IBackpackIntegration> integrationClass) {
            this.identifier = identifier;
            this.versionRange = versionRange;
            this.integrationClass = integrationClass;
        }
    }
}

