/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.Bukkit.API;

import at.pcgamingfreaks.Bukkit.Command.SubCommand;
import at.pcgamingfreaks.Bukkit.Message.Message;
import at.pcgamingfreaks.Command.HelpData;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriageMasterPlugin;
import at.pcgamingfreaks.MarriageMaster.Bukkit.API.MarriagePlayer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MarryCommand
extends SubCommand
implements at.pcgamingfreaks.MarriageMaster.API.MarryCommand<MarriageMasterPlugin, CommandSender> {
    private static MarriageMasterPlugin marriagePlugin = null;
    protected static final List<String> EMPTY_TAB_COMPLETE_LIST = Collections.unmodifiableList(new ArrayList(0));
    protected static final List<HelpData> EMPTY_HELP_LIST = Collections.unmodifiableList(new ArrayList(0));
    protected final JavaPlugin plugin;
    private static String helpPartnerSelector = "<partner name>";
    private static Message messageNoPermission = new Message(ChatColor.RED + "You don't have the permission to do that.");
    private static Message messageNotFromConsole = new Message(ChatColor.RED + "This command can't be used from console!");
    private static Message messageNotMarried = new Message(ChatColor.RED + "You are not married!");
    private static Method showHelp;
    private boolean playerOnly = false;
    private boolean mustBeMarried = false;
    private boolean partnerSelectorInHelp = false;

    protected MarryCommand(@NotNull JavaPlugin plugin, @NotNull String name, @NotNull String description, String ... aliases) {
        this(plugin, name, description, (String)null, aliases);
    }

    protected MarryCommand(@NotNull JavaPlugin plugin, @NotNull String name, @NotNull String description, @Nullable String permission, String ... aliases) {
        super(name, description, permission, aliases);
        this.plugin = plugin;
    }

    protected MarryCommand(@NotNull JavaPlugin plugin, @NotNull String name, @NotNull String description, @Nullable String permission, boolean playerOnly, String ... aliases) {
        this(plugin, name, description, permission, aliases);
        this.playerOnly = playerOnly;
    }

    protected MarryCommand(@NotNull JavaPlugin plugin, @NotNull String name, @NotNull String description, @Nullable String permission, boolean mustBeMarried, boolean partnerSelectorInHelpForMoreThanOnePartner, String ... aliases) {
        this(plugin, name, description, permission, true, aliases);
        this.mustBeMarried = mustBeMarried;
        this.partnerSelectorInHelp = partnerSelectorInHelpForMoreThanOnePartner;
    }

    @Override
    @NotNull
    public MarriageMasterPlugin getMarriagePlugin() {
        return marriagePlugin;
    }

    @Override
    public void doExecute(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, String ... args) {
        if (this.playerOnly && !(sender instanceof Player)) {
            messageNotFromConsole.send(sender, new Object[0]);
        } else if (this.getPermission() != null && !sender.hasPermission(this.getPermission())) {
            messageNoPermission.send(sender, new Object[0]);
        } else if (this.mustBeMarried && sender instanceof Player && !((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender)).isMarried()) {
            messageNotMarried.send(sender, new Object[0]);
        } else {
            this.execute(sender, mainCommandAlias, alias, args);
        }
    }

    @Override
    public List<String> doTabComplete(@NotNull CommandSender sender, @NotNull String mainCommandAlias, @NotNull String alias, String ... args) {
        if (this.playerOnly && !(sender instanceof Player)) {
            messageNotFromConsole.send(sender, new Object[0]);
        } else if (this.getPermission() == null || sender.hasPermission(this.getPermission())) {
            return this.tabComplete(sender, mainCommandAlias, alias, args);
        }
        return null;
    }

    @Override
    @Nullable
    public List<HelpData> getHelp(@NotNull CommandSender requester) {
        LinkedList<HelpData> help = new LinkedList<HelpData>();
        if (this.partnerSelectorInHelp && requester instanceof Player && ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)requester)).getPartners().size() > 1) {
            help.add(new HelpData(this.getTranslatedName(), helpPartnerSelector, this.getDescription()));
        } else {
            help.add(new HelpData(this.getTranslatedName(), null, this.getDescription()));
        }
        return help;
    }

    @Override
    public void showHelp(@NotNull CommandSender sendTo, @NotNull String usedMarryAlias) {
        try {
            showHelp.invoke(this.getMarriagePlugin().getCommandManager(), sendTo, usedMarryAlias, this.doGetHelp(sendTo));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to display help for user '" + sendTo.getName() + "'", e);
        }
    }

    @Override
    public boolean canUse(@NotNull CommandSender sender) {
        return (!this.playerOnly || sender instanceof Player) && (this.getPermission() == null || sender.hasPermission(this.getPermission()) && (!this.mustBeMarried || sender instanceof Player && ((MarriagePlayer)this.getMarriagePlugin().getPlayerData((Player)sender)).isMarried()));
    }
}

