/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.API;

import at.pcgamingfreaks.MarriageMaster.API.Marriage;
import at.pcgamingfreaks.Message.IMessage;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MarriagePlayer<MARRIAGE extends Marriage, MARRIAGE_PLAYER extends MarriagePlayer, PLAYER_OFFLINE, PLAYER_ONLINE, MESSAGE extends IMessage> {
    @NotNull
    public PLAYER_OFFLINE getPlayer();

    @Nullable
    public PLAYER_ONLINE getPlayerOnline();

    @NotNull
    public String getName();

    @NotNull
    public UUID getUUID();

    public boolean isOnline();

    public boolean canSee(PLAYER_ONLINE var1);

    public boolean canSee(MARRIAGE_PLAYER var1);

    @NotNull
    public String getDisplayName();

    public boolean hasPermission(@NotNull String var1);

    public boolean isPriest();

    public void setPriest(boolean var1);

    public boolean isSharingBackpack();

    public void setShareBackpack(boolean var1);

    public boolean isPrivateChatDefault();

    public void setPrivateChatDefault(boolean var1);

    @Nullable
    public MARRIAGE getPrivateChatTarget();

    public void setPrivateChatTarget(@Nullable MARRIAGE_PLAYER var1);

    public void setPrivateChatTarget(@Nullable MARRIAGE var1);

    public boolean isMarried();

    public boolean isPartner(@NotNull PLAYER_OFFLINE var1);

    public boolean isPartner(@NotNull MARRIAGE_PLAYER var1);

    @Nullable
    public MARRIAGE_PLAYER getPartner();

    @Nullable
    public MARRIAGE_PLAYER getPartner(String var1);

    @Nullable
    public MARRIAGE_PLAYER getPartner(UUID var1);

    @Nullable
    public MARRIAGE getMarriageData();

    @NotNull
    public Collection<? extends MARRIAGE_PLAYER> getPartners();

    @NotNull
    public Collection<? extends MARRIAGE> getMultiMarriageData();

    @Nullable
    public MARRIAGE getMarriageData(@NotNull MARRIAGE_PLAYER var1);

    @NotNull
    public List<String> getMatchingPartnerNames(@Nullable String var1);

    @NotNull
    default public Collection<? extends MARRIAGE_PLAYER> getOnlinePartners() {
        LinkedList onlinePartners = new LinkedList();
        this.getPartners().forEach(partner -> {
            if (partner.isOnline()) {
                onlinePartners.add(partner);
            }
        });
        return onlinePartners;
    }

    public void send(@NotNull MESSAGE var1, Object ... var2);

    public void sendMessage(@NotNull MESSAGE var1, Object ... var2);
}

