/*
 * Decompiled with CFR 0.152.
 */
package at.pcgamingfreaks.MarriageMaster.API;

import at.pcgamingfreaks.MarriageMaster.API.MarriagePlayer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;

public abstract class AcceptPendingRequest<T extends MarriagePlayer> {
    private final T playerThatHasToAccept;
    private final T[] playersThatCanCancel;
    private static Method closeMethod;

    @SafeVarargs
    protected AcceptPendingRequest(@NotNull T hasToAccept, T ... canCancel) {
        this.playerThatHasToAccept = hasToAccept;
        this.playersThatCanCancel = canCancel;
    }

    @NotNull
    public final T getPlayerThatHasToAccept() {
        return this.playerThatHasToAccept;
    }

    @NotNull
    public final T[] getPlayersThatCanCancel() {
        return this.playersThatCanCancel;
    }

    public final boolean canAccept(@NotNull T player) {
        return this.playerThatHasToAccept.equals(player);
    }

    public final boolean canDeny(@NotNull T player) {
        return this.playerThatHasToAccept.equals(player);
    }

    public final boolean canCancel(@NotNull T player) {
        for (T p : this.playersThatCanCancel) {
            if (!player.equals(p)) continue;
            return true;
        }
        return false;
    }

    public void accept(@NotNull T player) {
        if (this.canAccept(player)) {
            this.close();
            this.onAccept();
        }
    }

    public void deny(@NotNull T player) {
        if (this.canDeny(player)) {
            this.close();
            this.onDeny();
        }
    }

    public void cancel(@NotNull T player) {
        if (this.canCancel(player)) {
            this.close();
            this.onCancel(player);
        }
    }

    public void disconnect(@NotNull T player) {
        if (this.canAccept(player) || this.canCancel(player)) {
            this.close();
            this.onDisconnect(player);
        }
    }

    protected abstract void onAccept();

    protected abstract void onDeny();

    protected abstract void onCancel(@NotNull T var1);

    protected abstract void onDisconnect(@NotNull T var1);

    public final void close() {
        try {
            closeMethod.invoke(this.playerThatHasToAccept, this);
            for (T p : this.playersThatCanCancel) {
                if (p.equals(this.playerThatHasToAccept)) continue;
                closeMethod.invoke(p, this);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

