/*
 * Decompiled with CFR 0.152.
 */
package me.Dacaly.MapUtilities.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipOutputStream;
import me.Dacaly.MapUtilities.Main;
import me.Dacaly.MapUtilities.utils.ZipUtilities;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class MapCommand
implements CommandExecutor,
TabCompleter {
    public JavaPlugin plugin = Main.getPlugin(Main.class);

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        switch (args.length) {
            case 1: {
                args[0] = args[0].toLowerCase();
                break;
            }
            case 2: {
                args[1] = args[1].toLowerCase();
                break;
            }
            case 3: {
                args[2] = args[2].toLowerCase();
                break;
            }
            case 4: {
                args[3] = args[3].toLowerCase();
            }
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(Main.color("&cOnly players can execute this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length <= 0) {
            if (!(player.hasPermission("map.save") || player.hasPermission("map.load") || player.hasPermission("map.teleport"))) {
                player.sendMessage(Main.color("&cYou are not allowed to use this command!"));
                return true;
            }
            block35: for (int i = 0; i < Main.arrayList.size(); ++i) {
                switch (i) {
                    case 0: 
                    case 1: 
                    case 5: {
                        player.sendMessage(Main.arrayList.get(i));
                        continue block35;
                    }
                    case 2: {
                        if (!player.hasPermission("map.save")) continue block35;
                        player.sendMessage(Main.arrayList.get(i));
                        continue block35;
                    }
                    case 3: {
                        if (!player.hasPermission("map.load")) continue block35;
                        player.sendMessage(Main.arrayList.get(i));
                        continue block35;
                    }
                    case 4: {
                        if (!player.hasPermission("map.teleport")) continue block35;
                        player.sendMessage(Main.arrayList.get(i));
                    }
                }
            }
            return true;
        }
        switch (args[0]) {
            case "save": {
                if (!player.hasPermission("map.save")) {
                    player.sendMessage(Main.color("&cYou are not allowed to use this command!"));
                    return true;
                }
                if (args.length <= 1) {
                    player.sendMessage(Main.color("&cUsage: /map [save] [name]"));
                    return true;
                }
                if (new File(this.plugin.getDataFolder() + File.separator + "maps" + File.separator + args[1]).exists()) {
                    player.sendMessage(Main.color("&cA map with this name already exists!"));
                    return true;
                }
                try {
                    World world = player.getWorld();
                    world.save();
                    FileOutputStream fos = new FileOutputStream(this.plugin.getDataFolder() + File.separator + "maps" + File.separator + args[1] + ".zip");
                    ZipOutputStream zipOut = new ZipOutputStream(fos);
                    File worldToZip = world.getWorldFolder();
                    ZipUtilities.zipFile(worldToZip, worldToZip.getName(), zipOut, world.getName(), args[1]);
                    zipOut.close();
                    fos.close();
                    player.sendMessage(Main.color("&aSuccessfully saved the map!"));
                    return true;
                }
                catch (IOException e) {
                    player.sendMessage(Main.color("&cSomething went wrong, check console for details."));
                    e.printStackTrace();
                    return true;
                }
            }
            case "load": {
                if (!player.hasPermission("map.load")) {
                    player.sendMessage(Main.color("&cYou are not allowed to use this command!"));
                    return true;
                }
                if (args.length <= 2) {
                    player.sendMessage(Main.color("&cUsage: /map [load] [zip/world] [name]"));
                    return true;
                }
                File file1 = new File(this.plugin.getDataFolder() + File.separator + "maps" + File.separator + args[2] + ".zip");
                File file2 = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath() + "/" + args[2]);
                File file3 = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath() + "/" + args[2] + "/level.dat");
                switch (args[1]) {
                    case "world": {
                        if (!file3.exists()) {
                            player.sendMessage(Main.color("&cNo world with that name was found!"));
                            return true;
                        }
                        for (World world : this.plugin.getServer().getWorlds()) {
                            if (!world.getName().equalsIgnoreCase(args[2])) continue;
                            this.loadAndTeleport(player, world);
                            return true;
                        }
                        World world1 = new WorldCreator(args[2]).createWorld();
                        if (world1 == null) {
                            player.sendMessage(Main.color("&cSomething went wrong!"));
                            return true;
                        }
                        this.loadAndTeleport(player, world1);
                        break;
                    }
                    case "zip": {
                        if (!file1.exists()) {
                            player.sendMessage(Main.color("&cNo map with that name was found!"));
                            return true;
                        }
                        if (file2.exists()) {
                            player.sendMessage(Main.color("&cA folder with the name " + args[2] + " already exists!"));
                            return true;
                        }
                        try {
                            ZipFile zipFile = new ZipFile(this.plugin.getDataFolder() + File.separator + "maps" + File.separator + args[2] + ".zip");
                            zipFile.extractAll(this.plugin.getServer().getWorldContainer().getAbsolutePath());
                        }
                        catch (ZipException e) {
                            e.printStackTrace();
                        }
                        File worldFolder = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath() + "/" + args[2]);
                        if (!worldFolder.exists()) {
                            player.sendMessage(Main.color("&cSomething went wrong!"));
                            return true;
                        }
                        World world2 = new WorldCreator(args[2]).createWorld();
                        if (world2 == null) {
                            player.sendMessage(Main.color("&cSomething went wrong!"));
                            return true;
                        }
                        this.loadAndTeleport(player, world2);
                        break;
                    }
                    default: {
                        player.sendMessage(Main.color("&cUsage: /map [load] [zip/world] [name]"));
                        return true;
                    }
                }
                player.sendMessage(Main.color("&aSuccessfully loaded the map!"));
                return true;
            }
            case "teleport": 
            case "tp": {
                if (!player.hasPermission("map.teleport")) {
                    player.sendMessage(Main.color("&cYou are not allowed to use this command!"));
                    return true;
                }
                if (args.length <= 1) {
                    player.sendMessage(Main.color("&cUsage: /map [teleport] [world]"));
                    return true;
                }
                for (World world : Bukkit.getWorlds()) {
                    if (!world.getName().equalsIgnoreCase(args[1])) continue;
                    this.loadAndTeleport(player, world);
                    player.sendMessage(Main.color("&aTeleported you to: " + args[1]));
                    return true;
                }
                player.sendMessage(Main.color("&cThe world wasn't found/loaded!"));
                return true;
            }
        }
        for (String string : Main.arrayList) {
            player.sendMessage(string);
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, String label, String[] args) {
        if (label.equalsIgnoreCase("map")) {
            ArrayList<String> mainArguments = new ArrayList<String>();
            ArrayList<String> finalArguments = new ArrayList<String>();
            switch (args.length) {
                case 1: {
                    if (sender.hasPermission("map.load")) {
                        mainArguments.add("load");
                    }
                    if (sender.hasPermission("map.save")) {
                        mainArguments.add("save");
                    }
                    if (!sender.hasPermission("map.teleport")) break;
                    mainArguments.add("teleport");
                    break;
                }
                case 2: {
                    if (args[0].equalsIgnoreCase("teleport")) {
                        if (!sender.hasPermission("map.teleport")) break;
                        for (World world : Bukkit.getWorlds()) {
                            mainArguments.add(world.getName());
                        }
                        break;
                    }
                    if (!args[0].equalsIgnoreCase("load") || !sender.hasPermission("map.load")) break;
                    mainArguments.add("zip");
                    mainArguments.add("world");
                    break;
                }
                case 3: {
                    if (!args[0].equalsIgnoreCase("load") || !sender.hasPermission("map.load")) break;
                    if (args[1].equalsIgnoreCase("zip")) {
                        File file = new File(this.plugin.getDataFolder() + File.separator + "maps");
                        String[] maps = file.list();
                        if (maps == null) break;
                        for (String map : maps) {
                            if (!map.endsWith(".zip")) continue;
                            mainArguments.add(map.replaceAll("\\.zip", ""));
                        }
                    } else {
                        File file;
                        File[] maps;
                        if (!args[1].equalsIgnoreCase("world") || (maps = (file = new File(this.plugin.getServer().getWorldContainer().getAbsolutePath())).listFiles()) == null) break;
                        for (File map : maps) {
                            File file1;
                            if (!map.isDirectory() || !(file1 = new File(map.getAbsolutePath() + "/level.dat")).exists()) continue;
                            mainArguments.add(map.getName());
                        }
                    }
                    break;
                }
            }
            StringUtil.copyPartialMatches((String)args[Math.max(args.length - 1, 0)], mainArguments, finalArguments);
            Collections.sort(finalArguments);
            return finalArguments;
        }
        return null;
    }

    private void loadAndTeleport(Player player, World world) {
        Location location = new Location(world, 0.5, 100.0, 0.5);
        location.setY((double)(world.getHighestBlockYAt(location) + 1));
        player.teleport(location);
    }
}

