/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager.events;

import io.github.jeremgamer.maintenancemanager.MaintenanceManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.CachedServerIcon;

public class ListPingEvent
implements Listener {
    private CachedServerIcon maintenanceIcon;

    public ListPingEvent(Plugin plugin) {
        this.loadIcon();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadIcon() {
        block20: {
            File srcIcon = new File(String.valueOf(new File("").getAbsolutePath()) + "/maintenance-icon.png");
            if (!srcIcon.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        InputStream input = MaintenanceManager.class.getResourceAsStream("maintenance-icon.png");
                        try {
                            try (FileOutputStream output = new FileOutputStream(srcIcon);){
                                byte[] buf = new byte[8192];
                                while (true) {
                                    int len;
                                    if ((len = input.read(buf)) <= 0) {
                                        output.flush();
                                        input.close();
                                        ((OutputStream)output).close();
                                        break;
                                    }
                                    ((OutputStream)output).write(buf, 0, len);
                                }
                            }
                            if (input == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (input == null) throw throwable;
                            input.close();
                            throw throwable;
                        }
                        input.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        File icon = new File(String.valueOf(new File("").getAbsolutePath()) + "/maintenance-icon.png");
        try {
            BufferedImage maintenanceImage = ImageIO.read(icon);
            this.maintenanceIcon = Bukkit.getServer().loadServerIcon(maintenanceImage);
            return;
        }
        catch (Exception e) {
            MaintenanceManager.getInstance().getLogger().severe(e.getMessage());
        }
    }

    public CachedServerIcon getIcon() {
        return this.maintenanceIcon;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void MaintenanceListPing(ServerListPingEvent event) {
        if (MaintenanceManager.getHandler().isOn()) {
            block9: {
                if (MaintenanceManager.getHandler().isDurationEnabled()) {
                    try {
                        if (MaintenanceManager.getHandler().getRemainingTime() / 60 < 1) {
                            event.setMotd(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceWithDurationMOTDLessThanOneMinute").replaceAll("&", "\u00a7"));
                            break block9;
                        }
                        event.setMotd(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceWithDurationMOTD").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(MaintenanceManager.getHandler().getRemainingTime() / 60)));
                    }
                    catch (NumberFormatException e) {
                        MaintenanceManager.getInstance().getLogger().info(MaintenanceManager.getInstance().getCustomConfig().getString("inputErrorDuration").replaceAll("&", "\u00a7"));
                    }
                } else {
                    event.setMotd(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceMOTD").replaceAll("&", "\u00a7"));
                }
            }
            try {
                event.setServerIcon(this.maintenanceIcon);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            event.setMaxPlayers(MaintenanceManager.getInstance().getCustomConfig().getInt("maxPlayersOnMaintenance"));
        }
    }
}

