/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager.commands;

import io.github.jeremgamer.maintenancemanager.MaintenanceManager;
import io.github.jeremgamer.maintenancemanager.MaintenanceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MaintenanceCommand
implements CommandExecutor {
    private String help;

    public MaintenanceCommand() {
        this.loadHelp();
    }

    public void loadHelp() {
        InputStream input = MaintenanceManager.class.getResourceAsStream("help.yml");
        InputStreamReader isr = new InputStreamReader(input);
        this.help = "";
        try {
            BufferedReader bw = new BufferedReader(isr);
            int i = 0;
            while (i < 14) {
                this.help = String.valueOf(this.help) + bw.readLine() + "\n";
                this.help = this.help.replaceAll("&", "\u00a7");
                ++i;
            }
        }
        catch (IOException e) {
            MaintenanceManager.getInstance().getLogger().warning(e.getMessage());
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0 || args.length > 3) {
            sender.sendMessage(this.help);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload") && sender.hasPermission("maintenance.reload")) {
            if (sender instanceof Player) {
                sender.sendMessage("\u00a72\u00a7oReloading...");
            }
            MaintenanceManager.getInstance().reload();
            sender.sendMessage("\u00a72\u00a7oMaintenanceManager config reloaded!");
            return true;
        }
        if (args[0].equalsIgnoreCase("on") && sender.hasPermission("maintenance.maintenance")) {
            if (args.length == 1) {
                MaintenanceManager.getHandler().normalMaintenance(sender);
            } else {
                if (args.length == 2) {
                    try {
                        int scheduleTime = Integer.parseInt(args[1]);
                        MaintenanceManager.getHandler().scheduledMaintenance(sender, scheduleTime);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("inputErrorSchedule").replaceAll("&", "\u00a7"));
                        return true;
                    }
                }
                if (args.length == 3) {
                    int duration;
                    int scheduleTime = 0;
                    try {
                        scheduleTime = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("inputErrorSchedule").replaceAll("&", "\u00a7"));
                        return true;
                    }
                    try {
                        duration = Integer.parseInt(args[2]);
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("inputErrorDuration").replaceAll("&", "\u00a7"));
                        return true;
                    }
                    MaintenanceManager.getHandler().scheduledMaintenance(sender, scheduleTime, duration);
                }
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("off") && sender.hasPermission("maintenance.maintenance") && args.length == 1) {
            MaintenanceManager.getHandler().stopMaintenance(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("disable") && sender.hasPermission("maintenance.manage.plugins")) {
            if (args.length == 2) {
                MaintenanceUtils.disablePlugin(sender, args[1]);
            } else {
                sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginManagementArgumentErrorDisable").replaceAll("&", "\u00a7"));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("enable") && sender.hasPermission("maintenance.manage.plugins")) {
            if (args.length == 2) {
                MaintenanceUtils.enablePlugin(sender, args[1]);
            } else {
                sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginManagementArgumentErrorEnable").replaceAll("&", "\u00a7"));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("cancel") && sender.hasPermission("maintenance.maintenance.cancel") && args.length == 1) {
            MaintenanceManager.getHandler().cancelSchedule(sender);
            return true;
        }
        if (args[0].equalsIgnoreCase("backup") && sender.hasPermission("maintenance.backup")) {
            MaintenanceUtils.backup(sender);
            return true;
        }
        sender.sendMessage(this.help);
        return true;
    }
}

