/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.github.jeremgamer.maintenancemanager.MaintenanceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SaveFile {
    ArrayList<String> content = new ArrayList();

    public int getLineNumber() {
        return this.content.size();
    }

    public boolean containsSection(String section) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": ")) continue;
            return true;
        }
        return false;
    }

    public int indexOf(String section) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": ")) continue;
            return this.content.indexOf(line);
        }
        return -1;
    }

    public void createSection(String name, Object value) {
        this.content.add("");
        if (value instanceof String) {
            this.content.add(String.valueOf(name) + ": '" + value + "'");
        } else {
            this.content.add(String.valueOf(name) + ": " + value);
        }
    }

    public void createSection(int index, String name, Object value) {
        this.content.add(index, "");
        if (value instanceof String) {
            this.content.add(index + 1, String.valueOf(name) + ": '" + value + "'");
        } else {
            this.content.add(index + 1, String.valueOf(name) + ": " + value);
        }
    }

    public void removeSection(String name) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(name) + ": ")) continue;
            this.content.remove(this.content.indexOf(line) - 1);
            this.content.remove(line);
            break;
        }
    }

    public void set(String section, Object value) {
        int id = 0;
        for (String line : this.content) {
            if (line.startsWith(section)) {
                if (value instanceof String) {
                    this.content.set(id, String.valueOf(section) + ": '" + ((String)value).replaceAll("\n", "<n>") + "'");
                    return;
                }
                this.content.set(id, String.valueOf(section) + ": " + value);
                return;
            }
            ++id;
        }
        if (!this.containsSection(section)) {
            this.createSection(section, value);
        }
    }

    public String getString(String section) {
        String value = "";
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": '")) continue;
            value = line.substring(section.length() + 3);
            return value.substring(0, value.length() - 1).replaceAll("<n>", "\n");
        }
        MaintenanceManager.getInstance().getLogger().warning("Invalid value in \"" + section + "\" config section.");
        return "";
    }

    public int getInt(String section) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": ")) continue;
            try {
                int value = Integer.parseInt(line.substring(section.length() + 2));
                return value;
            }
            catch (NumberFormatException nfe) {
                MaintenanceManager.getInstance().getLogger().warning("Invalid value in \"" + section + "\" config section. Please don't modify this line.");
                this.set(section, 0);
                MaintenanceManager.getInstance().saveConfig();
                return -1;
            }
        }
        return -1;
    }

    public boolean getBoolean(String section) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": ")) continue;
            boolean value = Boolean.parseBoolean(line.substring(section.length() + 2));
            return value;
        }
        return false;
    }

    public List<String> getStringList(String section) {
        for (String line : this.content) {
            if (!line.startsWith(String.valueOf(section) + ": ")) continue;
            try {
                String raw = line.substring(section.length() + 2);
                ArrayList list = (ArrayList)new Gson().fromJson(raw, ArrayList.class);
                return list;
            }
            catch (JsonSyntaxException ise) {
                MaintenanceManager.getInstance().getLogger().warning("Invalid value in \"" + section + "\" config section. Please don't modify this line.");
                this.set(section, new ArrayList());
                MaintenanceManager.getInstance().saveConfig();
                return null;
            }
        }
        return null;
    }

    public void load(File file) throws IOException {
        try {
            FileReader fr = new FileReader(file.getAbsoluteFile());
            BufferedReader br = new BufferedReader(fr);
            this.content.clear();
            String line = br.readLine();
            while (line != null) {
                this.content.add(line);
                line = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public void save(File file) throws IOException {
        if (file.getName().equals("config.yml")) {
            if (!file.exists()) {
                File folders = new File(file.getParent());
                folders.mkdirs();
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            for (String line : this.content) {
                bw.write(String.valueOf(line) + "\n");
            }
            bw.flush();
            bw.close();
            fw.close();
        }
    }
}

