/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager;

import io.github.jeremgamer.maintenancemanager.MaintenanceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public abstract class MaintenanceUtils {
    private static boolean backingUp = false;
    private static ArrayList<String> disabledPlugins = new ArrayList();
    private static final String[] LIBRARIES = new String[]{"sigar-x86-winnt.dll", "sigar-amd64-winnt.dll", "libsigar-amd64-linux.so", "libsigar-x86-linux.so", "libsigar-universal-macosx.dylib", "libsigar-universal64-macosx.dylib"};

    public static Plugin getPluginIgnoreCase(String pluginName) {
        Plugin[] pluginArray = Bukkit.getPluginManager().getPlugins();
        int n = pluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            Plugin plugin = pluginArray[n2];
            if (plugin.getName().equalsIgnoreCase(pluginName)) {
                return plugin;
            }
            ++n2;
        }
        return null;
    }

    public static void disablePlugin(final String ... toDisable) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

            @Override
            public void run() {
                MaintenanceManager.getInstance().getLogger().info("Disabling plugins...");
                PluginManager pm = Bukkit.getPluginManager();
                String[] stringArray = toDisable;
                int n = toDisable.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    try {
                        Plugin plugin = pm.getPlugin(name);
                        pm.disablePlugin(plugin);
                        disabledPlugins.add(plugin.getName());
                    }
                    catch (NullPointerException e1) {
                        MaintenanceManager.getInstance().getLogger().severe("No plugin named " + name + " to disable!");
                    }
                    ++n2;
                }
            }
        }, 1L);
    }

    public static void enablePlugin(CommandSender sender, String toEnable) {
        try {
            Plugin plugin = MaintenanceUtils.getPluginIgnoreCase(toEnable);
            Bukkit.getPluginManager().enablePlugin(plugin);
            disabledPlugins.remove(plugin.getName());
            MaintenanceManager.getInstance().getCustomConfig().set("disabledPlugins", disabledPlugins);
            MaintenanceManager.getInstance().saveConfig();
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginEnabled").replaceAll("&", "\u00a7").replaceAll("<plugin>", plugin.getName()));
        }
        catch (NullPointerException e1) {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginManagementArgumentErrorEnable").replaceAll("&", "\u00a7"));
        }
    }

    public static void disablePlugin(CommandSender sender, String toDisable) {
        try {
            Plugin plugin = MaintenanceUtils.getPluginIgnoreCase(toDisable);
            Bukkit.getPluginManager().disablePlugin(plugin);
            disabledPlugins.add(plugin.getName());
            MaintenanceManager.getInstance().getCustomConfig().set("disabledPlugins", disabledPlugins);
            MaintenanceManager.getInstance().saveConfig();
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginDisabled").replaceAll("&", "\u00a7").replaceAll("<plugin>", plugin.getName()));
        }
        catch (NullPointerException e1) {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("pluginManagementArgumentErrorDisable").replaceAll("&", "\u00a7"));
        }
    }

    public static void backup(final CommandSender sender) {
        if (!backingUp) {
            backingUp = true;
            String folderPath = String.valueOf(new File("").getAbsolutePath()) + "/backups/";
            File folder = new File(folderPath);
            if (!folder.exists()) {
                if (folder.mkdir()) {
                    MaintenanceManager.getInstance().getLogger().info("Backup folder created!");
                } else {
                    MaintenanceManager.getInstance().getLogger().warning("Failed to create backup folder...");
                }
            }
            MaintenanceManager.getInstance().getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("backingUpMessage").replaceAll("&", "\u00a7"));
            MaintenanceManager.getInstance().getLogger().info("Backing up...");
            MaintenanceManager.getInstance().getServer().dispatchCommand((CommandSender)MaintenanceManager.getInstance().getServer().getConsoleSender(), "save-all");
            MaintenanceManager.getInstance().getServer().dispatchCommand((CommandSender)MaintenanceManager.getInstance().getServer().getConsoleSender(), "save-off");
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (sender != null) {
                        sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("backupSuccess").replaceAll("&", "\u00a7"));
                    }
                    MaintenanceManager.getInstance().getServer().dispatchCommand((CommandSender)MaintenanceManager.getInstance().getServer().getConsoleSender(), "save-on");
                    backingUp = false;
                }
            });
            MaintenanceUtils.backupProcess();
        } else if (sender != null) {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("alreadyBackingUp").replaceAll("&", "\u00a7"));
        }
    }

    private static void backupProcess() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MM dd - HH mm ss");
        String zipFile = String.valueOf(new File("").getAbsolutePath()) + "/backups/" + dateFormat.format(cal.getTime()) + ".zip";
        File zip = new File(zipFile);
        String srcDir = new File("").getAbsolutePath();
        try {
            try {
                zip.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File dir = new File(srcDir);
            List filesList = (List)FileUtils.listFilesAndDirs(dir, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
            File[] files = filesList.toArray(new File[filesList.size()]);
            FileOutputStream out = new FileOutputStream(zip);
            ZipArchiveOutputStream zipOutput = new ZipArchiveOutputStream(out);
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory() && !files[i].getAbsolutePath().contains(String.valueOf(new File("").getAbsolutePath()) + "\\backups\\")) {
                    String filePath = files[i].getAbsolutePath().substring(srcDir.length() + 1);
                    try {
                        ZipArchiveEntry entry = new ZipArchiveEntry(filePath);
                        entry.setSize(new File(files[i].getAbsolutePath()).length());
                        ((ArchiveOutputStream)zipOutput).putArchiveEntry(entry);
                        IOUtils.copy((InputStream)new FileInputStream(files[i].getAbsolutePath()), (OutputStream)zipOutput);
                        ((ArchiveOutputStream)zipOutput).closeArchiveEntry();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
            ((ArchiveOutputStream)zipOutput).finish();
            ((OutputStream)zipOutput).close();
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
        MaintenanceManager.getInstance().getLogger().info("Backup success!");
    }

    public static int getCpuUsage() throws SigarException {
        Sigar sigar = new Sigar();
        CpuPerc cpu = sigar.getCpuPerc();
        double cpuUsage = cpu.getUser() * 100.0 + cpu.getSys() * 100.0;
        int display = (int)cpuUsage;
        return display;
    }

    public static int getMemUsagePercent() throws SigarException {
        Sigar sigar = new Sigar();
        Mem mem = null;
        try {
            mem = sigar.getMem();
        }
        catch (SigarException se) {
            se.printStackTrace();
        }
        double MEMUse = mem.getUsedPercent();
        int displayPercent = (int)MEMUse;
        return displayPercent;
    }

    public static long getMemUsage() throws SigarException {
        Sigar sigar = new Sigar();
        Mem mem = null;
        try {
            mem = sigar.getMem();
        }
        catch (SigarException se) {
            se.printStackTrace();
        }
        long MEMUse = mem.getUsed() / 1024L / 1024L;
        return MEMUse;
    }

    public static boolean loadLibraries() throws IOException {
        String[] stringArray = LIBRARIES;
        int n = LIBRARIES.length;
        int n2 = 0;
        while (n2 < n) {
            int len;
            String s = stringArray[n2];
            File lib = new File(String.valueOf(new File("").getAbsolutePath()) + "/" + s);
            InputStream input = MaintenanceManager.class.getResourceAsStream(s);
            if (input == null) {
                return false;
            }
            FileOutputStream output = new FileOutputStream(lib);
            byte[] buf = new byte[8192];
            while ((len = input.read(buf)) > 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
            output.flush();
            input.close();
            ((OutputStream)output).close();
            ++n2;
        }
        return true;
    }
}

