/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager;

import io.github.jeremgamer.maintenancemanager.Handler;
import io.github.jeremgamer.maintenancemanager.MaintenanceUtils;
import io.github.jeremgamer.maintenancemanager.SaveFile;
import io.github.jeremgamer.maintenancemanager.commands.CpuCommand;
import io.github.jeremgamer.maintenancemanager.commands.MaintenanceCommand;
import io.github.jeremgamer.maintenancemanager.commands.RamCommand;
import io.github.jeremgamer.maintenancemanager.events.JoinEvent;
import io.github.jeremgamer.maintenancemanager.events.ListPingEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MaintenanceManager
extends JavaPlugin {
    public static final String VERSION = "2.2";
    public static final String DOWNLOAD_ADDRESS = "goo.gl/8Tojtm";
    private static final String RELEASE_MANIFEST = "https://github.com/JeremGamer/MaintenanceManager/blob/master/RELEASE_MANIFEST.version";
    private static MaintenanceManager instance;
    private static Handler handler;
    private static boolean upToDate;
    private static boolean libsLoaded;
    private ListPingEvent listPing;
    private MaintenanceCommand command;
    private SaveFile config;
    private File configFile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkUpdate() {
        if (!MaintenanceManager.checkInternet()) {
            return true;
        }
        try {
            String s;
            InputStream is;
            URL u = new URL(RELEASE_MANIFEST);
            try {
                is = u.openStream();
            }
            catch (FileNotFoundException fnfe) {
                return true;
            }
            DataInputStream dis = new DataInputStream(new BufferedInputStream(is));
            do {
                if ((s = dis.readLine()) != null) continue;
                return true;
            } while (!s.contains("VERSION:"));
            String version = s.substring(s.indexOf(":VERSION:"), s.lastIndexOf(":VERSION:"));
            if ((version = version.substring(":VERSION:".length())).equals(VERSION)) return true;
            this.getLogger().info("MaintenanceManager isn't up to date! Get the " + version + " version here: " + DOWNLOAD_ADDRESS);
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean checkInternet() {
        try {
            URL url = new URL("http://www.google.com");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.connect();
            if (con.getResponseCode() == 200) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static MaintenanceManager getInstance() {
        return instance;
    }

    public static Handler getHandler() {
        return handler;
    }

    public static boolean isUpToDate() {
        return upToDate;
    }

    public void onEnable() {
        instance = this;
        this.initConfig();
        handler = new Handler();
        upToDate = this.checkUpdate();
        this.initEvents();
        try {
            libsLoaded = MaintenanceUtils.loadLibraries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.registerCommands();
    }

    private void registerCommands() {
        this.getLogger().info("Registering commands...");
        this.command = new MaintenanceCommand();
        this.getCommand("maintenance").setExecutor((CommandExecutor)this.command);
        if (libsLoaded) {
            this.getCommand("cpu").setExecutor((CommandExecutor)new CpuCommand());
            this.getCommand("ram").setExecutor((CommandExecutor)new RamCommand());
        }
    }

    private void initEvents() {
        this.getLogger().info("Initializing events...");
        this.listPing = new ListPingEvent((Plugin)this);
        new JoinEvent((Plugin)this);
    }

    public void reload() {
        this.getLogger().info("Reloading...");
        this.reloadConfig();
        handler.initSavedData();
        this.listPing.loadIcon();
        this.command.loadHelp();
        upToDate = this.checkUpdate();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (MaintenanceManager.isUpToDate() || !p.isOp()) continue;
            p.sendMessage("\u00a7c\u00a7lYour MaintenanceManager is outdated! \n\u00a76\u00a7oGet the latest version here: \u00a7e\u00a7ngoo.gl/8Tojtm");
        }
    }

    private void initConfig() {
        this.config = new SaveFile();
        this.configFile = new File(MaintenanceManager.getInstance().getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            MaintenanceManager.getInstance().saveDefaultConfig();
        }
        try {
            this.config.load(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.updateConfig();
    }

    private void updateConfig() {
        if (!this.config.containsSection("scheduleMessageSeconds")) {
            this.config.createSection(this.config.indexOf("scheduleMessage") + 1, "scheduleMessageSeconds", "&5&oMaintenance in &4&l<seconds> &5&oseconds!");
            try {
                this.config.save(this.configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reloadConfig() {
        try {
            if (!this.configFile.exists()) {
                this.config.save(this.configFile);
            } else {
                this.config.load(this.configFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public SaveFile getCustomConfig() {
        return this.config;
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

