/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremgamer.maintenancemanager;

import io.github.jeremgamer.maintenancemanager.MaintenanceManager;
import io.github.jeremgamer.maintenancemanager.MaintenanceUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Handler {
    private boolean maintenanceTime;
    private boolean scheduleEnabled;
    private boolean durationEnabled;
    private int scheduleTask = -1;
    private int durationTask = -1;
    private int duration = -1;
    private int scheduleTime = -1;

    Handler() {
        this.initSavedData();
    }

    public void initSavedData() {
        List<String> disabledPlugins = MaintenanceManager.getInstance().getCustomConfig().getStringList("disabledPlugins");
        if (disabledPlugins != null && !disabledPlugins.isEmpty()) {
            MaintenanceUtils.disablePlugin(disabledPlugins.toArray(new String[disabledPlugins.size()]));
        }
        this.duration = MaintenanceManager.getInstance().getCustomConfig().getInt("remainingSeconds");
        if (this.duration == -1) {
            return;
        }
        if (this.duration != 0) {
            this.maintenanceWithDuration(this.duration / 60);
        } else {
            this.maintenanceTime = MaintenanceManager.getInstance().getCustomConfig().getBoolean("maintenanceModeOnStart");
        }
    }

    public boolean isOn() {
        return this.maintenanceTime;
    }

    public boolean isScheduleEnabled() {
        return this.scheduleEnabled;
    }

    public boolean isDurationEnabled() {
        return this.durationEnabled;
    }

    public int getRemainingTime() {
        return this.duration;
    }

    private void decrementDuration() {
        --this.duration;
    }

    private void decrementSchedule() {
        --this.scheduleTime;
    }

    public int getScheduleTime() {
        return this.scheduleTime;
    }

    private void setScheduleTime(int time) {
        this.scheduleTime = time;
    }

    public void normalMaintenance(CommandSender sender) {
        if (!this.maintenanceTime) {
            if (!this.scheduleEnabled) {
                this.maintenanceTime = true;
                MaintenanceManager.getInstance().getCustomConfig().set("maintenanceModeOnStart", true);
                MaintenanceManager.getInstance().saveConfig();
                Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceStart").replaceAll("&", "\u00a7"));
                Bukkit.getScheduler().runTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                            if (player.hasPermission("maintenance.access") || player.isOp()) continue;
                            player.kickPlayer(MaintenanceManager.getInstance().getCustomConfig().getString("kickMessage").replaceAll("&", "\u00a7"));
                        }
                    }
                });
            } else {
                sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyScheduled").replaceAll("&", "\u00a7"));
            }
        } else {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyLaunched").replaceAll("&", "\u00a7"));
        }
    }

    public void normalMaintenance() {
        if (!this.maintenanceTime && !this.scheduleEnabled) {
            this.maintenanceTime = true;
            MaintenanceManager.getInstance().getCustomConfig().set("maintenanceModeOnStart", true);
            MaintenanceManager.getInstance().saveConfig();
            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceStart").replaceAll("&", "\u00a7"));
            Bukkit.getScheduler().runTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                        if (player.hasPermission("maintenance.access") || player.isOp()) continue;
                        player.kickPlayer(MaintenanceManager.getInstance().getCustomConfig().getString("kickMessage").replaceAll("&", "\u00a7"));
                    }
                }
            });
        }
    }

    public void scheduledMaintenance(CommandSender sender, final int scheduleTime) {
        if (!this.maintenanceTime) {
            if (!this.scheduleEnabled) {
                if (scheduleTime <= 0) {
                    this.normalMaintenance();
                    return;
                }
                Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(scheduleTime)));
                this.setScheduleTime(scheduleTime * 60);
                this.scheduleEnabled = true;
                this.scheduleTask = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        Handler.this.decrementSchedule();
                        if (Handler.this.getScheduleTime() <= 0) {
                            Handler.this.scheduleEnabled = false;
                            Bukkit.getScheduler().cancelTask(Handler.this.scheduleTask);
                            Handler.this.normalMaintenance();
                        } else if (Handler.this.getScheduleTime() == 60) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleLessThanOneMinute").replaceAll("&", "\u00a7"));
                        } else if (Handler.this.getScheduleTime() == 120 && scheduleTime > 2 || Handler.this.getScheduleTime() == 180 && scheduleTime > 3 || Handler.this.getScheduleTime() == 240 && scheduleTime > 4 || Handler.this.getScheduleTime() == 300 && scheduleTime > 5) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(Handler.this.getScheduleTime() / 60)));
                        } else if (Handler.this.getScheduleTime() == scheduleTime * 60 / 2 && Handler.this.getScheduleTime() > 60) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(Handler.this.getScheduleTime() / 60)));
                        } else if (Handler.this.getScheduleTime() <= 10) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessageSeconds").replaceAll("&", "\u00a7").replaceAll("<seconds>", String.valueOf(Handler.this.getScheduleTime())));
                        }
                    }
                }, 0L, 20L);
            } else {
                sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyScheduled").replaceAll("&", "\u00a7"));
            }
        } else {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyLaunched").replaceAll("&", "\u00a7"));
        }
    }

    public void scheduledMaintenance(CommandSender sender, final int scheduleTime, final int duration) {
        if (!this.maintenanceTime) {
            if (!this.scheduleEnabled) {
                if (scheduleTime <= 0) {
                    this.maintenanceWithDuration(duration);
                    return;
                }
                Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(scheduleTime)));
                this.setScheduleTime(scheduleTime * 60);
                this.scheduleEnabled = true;
                this.scheduleTask = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        Handler.this.decrementSchedule();
                        if (Handler.this.getScheduleTime() <= 0) {
                            Handler.this.scheduleEnabled = false;
                            Bukkit.getScheduler().cancelTask(Handler.this.scheduleTask);
                            Handler.this.maintenanceWithDuration(duration);
                        } else if (Handler.this.getScheduleTime() == 60) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleLessThanOneMinute").replaceAll("&", "\u00a7"));
                        } else if (Handler.this.getScheduleTime() == 120 && scheduleTime > 2 || Handler.this.getScheduleTime() == 180 && scheduleTime > 3 || Handler.this.getScheduleTime() == 240 && scheduleTime > 4 || Handler.this.getScheduleTime() == 300 && scheduleTime > 5) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(Handler.this.getScheduleTime() / 60)));
                        } else if (Handler.this.getScheduleTime() == scheduleTime * 60 / 2 && Handler.this.getScheduleTime() > 60) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessage").replaceAll("&", "\u00a7").replaceAll("<minutes>", String.valueOf(Handler.this.getScheduleTime() / 60)));
                        } else if (Handler.this.getScheduleTime() <= 10) {
                            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleMessageSeconds").replaceAll("&", "\u00a7").replaceAll("<seconds>", String.valueOf(Handler.this.getScheduleTime())));
                        }
                    }
                }, 0L, 20L);
            } else {
                sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyScheduled").replaceAll("&", "\u00a7"));
            }
        } else {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceAlreadyLaunched").replaceAll("&", "\u00a7"));
        }
    }

    public void maintenanceWithDuration(double duration) {
        if (this.maintenanceTime) {
            return;
        }
        if (!this.scheduleEnabled) {
            this.duration = (int)(duration * 60.0);
            this.normalMaintenance();
            this.durationEnabled = true;
            this.durationTask = Bukkit.getScheduler().scheduleAsyncRepeatingTask((Plugin)MaintenanceManager.getInstance(), new Runnable(){

                @Override
                public void run() {
                    Handler.this.decrementDuration();
                    MaintenanceManager.getInstance().getCustomConfig().set("remainingSeconds", Handler.this.getRemainingTime());
                    MaintenanceManager.getInstance().saveConfig();
                    if (Handler.this.getRemainingTime() <= 0) {
                        Handler.this.stopMaintenance();
                    }
                }
            }, 0L, 20L);
        }
    }

    public void stopMaintenance(CommandSender sender) {
        if (this.maintenanceTime) {
            if (this.durationEnabled) {
                Bukkit.getScheduler().cancelTask(this.durationTask);
                this.durationEnabled = false;
                this.duration = -1;
            }
            this.maintenanceTime = false;
            MaintenanceManager.getInstance().getCustomConfig().set("maintenanceModeOnStart", false);
            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceEnd").replaceAll("&", "\u00a7"));
            MaintenanceManager.getInstance().saveConfig();
        } else {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("noMaintenanceLaunched").replaceAll("&", "\u00a7"));
        }
    }

    public void stopMaintenance() {
        if (this.maintenanceTime) {
            if (this.durationEnabled) {
                Bukkit.getScheduler().cancelTask(this.durationTask);
                this.durationEnabled = false;
                this.duration = -1;
            }
            this.maintenanceTime = false;
            MaintenanceManager.getInstance().getCustomConfig().set("maintenanceModeOnStart", false);
            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("maintenanceEnd").replaceAll("&", "\u00a7"));
            MaintenanceManager.getInstance().saveConfig();
        }
    }

    public void cancelSchedule() {
        if (this.scheduleEnabled) {
            Bukkit.getScheduler().cancelTask(this.scheduleTask);
            this.scheduleEnabled = false;
            this.scheduleTime = -1;
            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleCanceled").replaceAll("&", "\u00a7"));
        }
    }

    public void cancelSchedule(CommandSender sender) {
        if (this.scheduleEnabled) {
            Bukkit.getScheduler().cancelTask(this.scheduleTask);
            this.scheduleEnabled = false;
            this.scheduleTime = -1;
            Bukkit.getServer().broadcastMessage(MaintenanceManager.getInstance().getCustomConfig().getString("scheduleCanceled").replaceAll("&", "\u00a7"));
        } else {
            sender.sendMessage(MaintenanceManager.getInstance().getCustomConfig().getString("noMaintenanceScheduled").replaceAll("&", "\u00a7"));
        }
    }
}

