/*
 * Decompiled with CFR 0.152.
 */
package me.mosckydev.mtaser.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private File file;
    private JavaPlugin instance;
    private YamlConfiguration config;

    public FileManager(JavaPlugin instance, String file) {
        this.file = new File(instance.getDataFolder(), file);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            instance.saveResource(file, false);
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.file);
            this.config = YamlConfiguration.loadConfiguration((File)this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Location getLocation(String path) {
        Location location = new Location(Bukkit.getWorld((String)this.config.getString(path + ".world")), this.config.getDouble(path + ".x"), this.config.getDouble(path + ".y"), this.config.getDouble(path + ".z"), ((Float)this.config.get(path + ".yaw")).floatValue(), ((Float)this.config.get(path + ".pitch")).floatValue());
        return location;
    }

    public void setLocation(String path, Location location) {
        this.config.set(path + ".world", (Object)location.getWorld().getName());
        this.config.set(path + ".x", (Object)location.getX());
        this.config.set(path + ".y", (Object)location.getY());
        this.config.set(path + ".z", (Object)location.getZ());
        this.config.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        this.config.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public Integer getInt(String path) {
        return this.config.getInt(path);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.config.getDoubleList(path);
    }

    public List<Long> getLongList(String path) {
        return this.config.getLongList(path);
    }

    public List<Short> getShortList(String path) {
        return this.config.getShortList(path);
    }

    public Object get(String path) {
        return this.config.get(path);
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public void set(String path, Object object) {
        this.config.set(path, object);
    }

    public boolean contains(String value) {
        AtomicBoolean status = new AtomicBoolean(false);
        this.config.getKeys(false).forEach(string -> {
            if (string.equals(value)) {
                status.set(true);
            }
        });
        return status.get();
    }
}

