/*
 * Decompiled with CFR 0.152.
 */
package me.mosckydev.mtaser.utils;

import me.mosckydev.mtaser.utils.ChatUtils;
import me.mosckydev.mtaser.utils.CommandException;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class CommandCreator
implements CommandExecutor {
    public CommandCreator(JavaPlugin instance, String name) {
        instance.getCommand(name).setExecutor((CommandExecutor)this);
    }

    public abstract void command(CommandSender var1, String[] var2);

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        try {
            this.command(sender, args);
        }
        catch (CommandException e) {
            sender.sendMessage(e.getMessage());
        }
        return false;
    }

    public void setCondition(boolean condition, String errormsg) {
        if (!condition) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void checkPermission(CommandSender sender, String permission) {
        if (!sender.hasPermission(permission)) {
            throw new CommandException("\u00a77\u00a7l\u00bb \u00a7cNon hai il permesso per eseguire questo comando.");
        }
    }

    public void checkPermission(CommandSender sender, String permission, String errormsg) {
        if (!sender.hasPermission(permission)) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void isInteger(String numberCheck) {
        try {
            Integer.parseInt(numberCheck);
        }
        catch (NumberFormatException e) {
            throw new CommandException("\u00a77\u00a7l\u00bb \u00a7cDevi inserire un numero valido!");
        }
    }

    public void isInteger(String numberCheck, String errormsg) {
        try {
            Integer.parseInt(numberCheck);
        }
        catch (NumberFormatException e) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void checkMinArgs(String[] args, int min) {
        if (args.length < min) {
            throw new CommandException("\u00a77\u00a7l\u00bb \u00a7cCompleta il comando con pi\u00f9 argomenti.");
        }
    }

    public void checkMinArgs(String[] args, int min, String errormsg) {
        if (args.length < min) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void isPlayer(CommandSender sender) {
        if (!(sender instanceof Player)) {
            throw new CommandException("\u00a77\u00a7l\u00bb \u00a7cDevi essere un player per eseguire questo comando.");
        }
    }

    public void isPlayer(CommandSender sender, String errormsg) {
        if (!(sender instanceof Player)) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void isNull(Object object, String errormsg) {
        if (object == null) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public void sendMessage(CommandSender sender, String msg) {
        sender.sendMessage(ChatUtils.colorChat(msg));
    }

    public void isValidPlayerOnline(String player, String errormsg) {
        Bukkit.getPlayerExact((String)player);
        if (!Bukkit.getPlayerExact((String)player).isOnline()) {
            throw new CommandException(ChatUtils.colorChat(errormsg));
        }
    }

    public boolean errorMessage(String errormsg) {
        throw new CommandException(ChatUtils.colorChat(errormsg));
    }
}

