/*
 * Decompiled with CFR 0.152.
 */
package teammt.mtdeathlocator.commands;

import java.io.IOException;
import masecla.mlib.annotations.RegisterableInfo;
import masecla.mlib.annotations.SubcommandInfo;
import masecla.mlib.classes.Registerable;
import masecla.mlib.classes.Replaceable;
import masecla.mlib.main.MLib;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import teammt.mtdeathlocator.managers.DeathTracking;

@RegisterableInfo(command="death")
public class DeathCommand
extends Registerable {
    private DeathTracking deathTracking;

    public DeathCommand(MLib lib, DeathTracking deathTracking) {
        super(lib);
        this.deathTracking = deathTracking;
    }

    @Override
    public void fallbackCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("teammt.deathlocator.help")) {
            this.lib.getMessagesAPI().sendMessage("no-permission", sender, new Replaceable[0]);
            return;
        }
        this.lib.getMessagesAPI().sendMessage("help", sender, new Replaceable[0]);
    }

    @SubcommandInfo(subcommand="reload", permission="teammt.deathlocator.reload")
    public void handleReload(CommandSender sender) {
        try {
            this.lib.getConfigurationAPI().reloadAll();
            this.lib.getMessagesAPI().reloadSharedConfig();
            this.lib.getMessagesAPI().sendMessage("plugin-reloaded", sender, new Replaceable[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SubcommandInfo(subcommand="find", permission="teammt.deathlocator.find.self")
    public void handleFindSelf(Player pl) {
        this.handleFindSelf(pl, pl.getName());
    }

    @SubcommandInfo(subcommand="find", permission="teammt.deathlocator.find.other")
    public void handleFindSelf(Player pl, String target) {
        OfflinePlayer trg = Bukkit.getOfflinePlayer((String)target);
        if (trg == null || !trg.hasPlayedBefore()) {
            this.lib.getMessagesAPI().sendMessage("invalid-player", (CommandSender)pl, new Replaceable[0]);
            return;
        }
        Location l = this.deathTracking.getLastDeathLocation(trg.getPlayer());
        if (l == null) {
            this.lib.getMessagesAPI().sendMessage("no-death", (CommandSender)pl, new Replaceable[0]);
            return;
        }
        this.lib.getMessagesAPI().sendMessage("your-location", (CommandSender)pl, new Replaceable("%x%", l.getBlockX()), new Replaceable("%y%", l.getBlockY()), new Replaceable("%z%", l.getBlockZ()), new Replaceable("%world%", l.getWorld().getName()), new Replaceable("%player%", trg.getName()));
    }

    @SubcommandInfo(subcommand="teleport", permission="teammt.deathlocator.teleport.self")
    public void handleTeleport(Player player) {
        this.handleTeleport(player, player.getName());
    }

    @SubcommandInfo(subcommand="teleport", permission="teammt.deathlocator.teleport.others")
    public void handleTeleport(Player pl, String target) {
        OfflinePlayer trg = Bukkit.getOfflinePlayer((String)target);
        if (trg == null || !trg.hasPlayedBefore()) {
            this.lib.getMessagesAPI().sendMessage("invalid-player", (CommandSender)pl, new Replaceable[0]);
            return;
        }
        Location l = (Location)this.lib.getConfigurationAPI().getConfig("deaths").get(trg.getUniqueId() + ".lastlocation", null);
        if (l == null) {
            this.lib.getMessagesAPI().sendMessage("no-death", (CommandSender)pl, new Replaceable[0]);
            return;
        }
        this.lib.getMessagesAPI().sendMessage("teleported", (CommandSender)pl, new Replaceable[0]);
        pl.teleport(l);
    }
}

