/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.containers.instances;

import java.util.ArrayList;
import java.util.List;
import masecla.mlib.containers.generic.PagedContainer;
import masecla.mlib.main.MLib;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class SquaredPagedContainer
extends PagedContainer {
    public SquaredPagedContainer(MLib lib) {
        super(lib);
    }

    @Override
    public boolean requiresUpdating() {
        return true;
    }

    @Override
    public void onDrop(PlayerDropItemEvent event) {
        event.setCancelled(true);
    }

    @Override
    public abstract void usableClick(InventoryClickEvent var1);

    @Override
    public List<Integer> getUsableSlots(Player player) {
        ArrayList<Integer> usables = new ArrayList<Integer>();
        for (int i = 0; i < this.getSize(player) - 9; ++i) {
            usables.add(i);
        }
        return usables;
    }

    @Override
    public Inventory applyGUIElements(Player player, Inventory contentFilledInventory, int currentPage, int maxPage) {
        ItemStack result = null;
        try {
            Material m = Enum.valueOf(Material.class, "STAINED_GLASS_PANE");
            result = new ItemStack(m, 1, 15);
        }
        catch (Exception e) {
            Material m = Enum.valueOf(Material.class, "BLACK_STAINED_GLASS_PANE");
            result = new ItemStack(m);
        }
        ItemMeta theMeta = result.getItemMeta();
        theMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)" "));
        result.setItemMeta(theMeta);
        int size = this.getSize(player);
        for (int i = 0; i < 9; ++i) {
            contentFilledInventory.setItem(i + size - 9, result);
        }
        contentFilledInventory.setItem(this.getPreviousPageItemPosition(player), this.getPreviousPageItem(player, currentPage, maxPage));
        contentFilledInventory.setItem(this.getNextPageItemPosition(player), this.getNextPageItem(player, currentPage, maxPage));
        return contentFilledInventory;
    }

    @Override
    public int getNextPageItemPosition(Player player) {
        return this.getSize(player) - 2;
    }

    @Override
    public int getPreviousPageItemPosition(Player player) {
        return this.getSize(player) - 8;
    }
}

