/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.containers.generic;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import masecla.mlib.containers.generic.GenericContainer;
import masecla.mlib.main.MLib;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public abstract class PagedContainer
extends GenericContainer {
    private HashMap<UUID, Integer> currentPages = new HashMap();
    private Map<UUID, Integer> maxPages = new HashMap<UUID, Integer>();
    private Map<UUID, List<ItemStack>> cachedItems = new HashMap<UUID, List<ItemStack>>();
    private Map<UUID, Long> cachedItemsAge = new HashMap<UUID, Long>();

    public PagedContainer(MLib lib) {
        super(lib);
    }

    public String getTitle(Player player) {
        return "Chest";
    }

    @Override
    public boolean requiresUpdating() {
        return true;
    }

    @Override
    public void onOpen(Player player) {
        UUID playerId = player.getUniqueId();
        this.currentPages.put(playerId, 0);
        this.cachedItems.remove(playerId);
        this.cachedItemsAge.remove(playerId);
    }

    @Override
    public void onClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        UUID playerId = player.getUniqueId();
        this.currentPages.remove(playerId);
        this.maxPages.remove(playerId);
        this.cachedItems.remove(playerId);
        this.cachedItemsAge.remove(playerId);
    }

    public int getNumberOfPagesFor(Player player, int usableSlotCount, int itemsCount) {
        return itemsCount / usableSlotCount + (itemsCount % usableSlotCount == 0 ? 0 : 1);
    }

    public int getCurrentPageFor(Player player) {
        return this.currentPages.getOrDefault(player.getUniqueId(), 0);
    }

    public int getMaxPageFor(Player player) {
        return this.maxPages.getOrDefault(player.getUniqueId(), 0);
    }

    public ItemStack getNextPageItem(Player player, int currentPage, int maxPage) {
        ItemStack result = new ItemStack(Material.ARROW, 1);
        ItemMeta theMeta = result.getItemMeta();
        theMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aNext page"));
        ArrayList<String> thelore = new ArrayList<String>();
        thelore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8Page " + currentPage + "/" + maxPage)));
        theMeta.setLore(thelore);
        result.setItemMeta(theMeta);
        return result;
    }

    public ItemStack getPreviousPageItem(Player player, int currentPage, int maxPage) {
        ItemStack result = new ItemStack(Material.ARROW, 1);
        ItemMeta theMeta = result.getItemMeta();
        theMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&aPrevious page"));
        ArrayList<String> thelore = new ArrayList<String>();
        thelore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8Page " + currentPage + "/" + maxPage)));
        theMeta.setLore(thelore);
        result.setItemMeta(theMeta);
        return result;
    }

    public void nextPage(Player player, int currentPage, int maxPage) {
        if (currentPage < maxPage - 1) {
            this.currentPages.put(player.getUniqueId(), currentPage + 1);
        }
    }

    public void previousPage(Player player, int currentPage, int maxPage) {
        if (currentPage > 0) {
            this.currentPages.put(player.getUniqueId(), currentPage - 1);
        }
    }

    public boolean isUsable(Player player, int slot) {
        return this.getUsableSlots(player).contains(slot);
    }

    @Override
    public boolean updateOnClick() {
        return true;
    }

    public abstract List<Integer> getUsableSlots(Player var1);

    public abstract List<ItemStack> getOrderableItems(Player var1);

    private final List<ItemStack> getItems(Player player) {
        if (this.cachedItems.containsKey(player.getUniqueId())) {
            long age = this.cachedItemsAge.get(player.getUniqueId());
            if (Instant.now().toEpochMilli() - age > (long)(this.getUpdatingInterval() * 50)) {
                this.cachedItems.remove(player.getUniqueId());
                this.cachedItemsAge.remove(player.getUniqueId());
                return this.getItems(player);
            }
            return this.cachedItems.get(player.getUniqueId());
        }
        List<ItemStack> cr = this.getOrderableItems(player);
        this.cachedItems.put(player.getUniqueId(), cr);
        this.cachedItemsAge.put(player.getUniqueId(), Instant.now().toEpochMilli());
        return cr;
    }

    public Inventory createContentInventoryFor(Player player, int currentPage) {
        int startIndex;
        Inventory inv = Bukkit.createInventory(null, (int)this.getSize(player), (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.getTitle(player)));
        List<ItemStack> items = this.getItems(player);
        List<Integer> usableSlots = this.getUsableSlots(player);
        int maxPage = this.getNumberOfPagesFor(player, usableSlots.size(), items.size());
        this.maxPages.put(player.getUniqueId(), maxPage);
        for (int i = startIndex = currentPage * usableSlots.size(); i < startIndex + Math.min(usableSlots.size(), items.size() - startIndex); ++i) {
            inv.setItem(usableSlots.get(i - startIndex).intValue(), items.get(i));
        }
        return inv;
    }

    public abstract Inventory applyGUIElements(Player var1, Inventory var2, int var3, int var4);

    public abstract int getPreviousPageItemPosition(Player var1);

    public abstract int getNextPageItemPosition(Player var1);

    @Override
    public Inventory getInventory(Player player) {
        int currentPage = this.currentPages.getOrDefault(player.getUniqueId(), 0);
        Inventory filled = this.createContentInventoryFor(player, currentPage);
        int maxPage = this.maxPages.get(player.getUniqueId());
        filled = this.applyGUIElements(player, filled, currentPage + 1, maxPage);
        return filled;
    }

    @Override
    public void onTopClick(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.updateOnClick()) {
            UUID uniqueId = event.getWhoClicked().getUniqueId();
            this.cachedItems.remove(uniqueId);
            this.cachedItemsAge.remove(uniqueId);
        }
        if (this.getUsableSlots((Player)event.getWhoClicked()).contains(event.getRawSlot())) {
            this.usableClick(event);
        } else {
            Player cr = (Player)event.getWhoClicked();
            int currentPage = this.getCurrentPageFor(cr);
            int maxPage = this.maxPages.getOrDefault(cr.getUniqueId(), 0);
            if (event.getRawSlot() == this.getPreviousPageItemPosition(cr)) {
                this.previousPage(cr, currentPage, maxPage);
            }
            if (event.getRawSlot() == this.getNextPageItemPosition(cr)) {
                this.nextPage(cr, currentPage, maxPage);
            }
        }
    }

    @Override
    public void onBottomClick(InventoryClickEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void onDrag(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    public abstract void usableClick(InventoryClickEvent var1);
}

