/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import masecla.mlib.classes.sql.SQLQuery;

public class SelectQuery
extends SQLQuery {
    private String tableActingOn;
    private String selections;
    private List<String> searchColumns = new ArrayList<String>();
    private List<Object> searchValues = new ArrayList<Object>();

    public SelectQuery(Connection connection, String tableActingOn, String ... toSelect) {
        super(connection);
        this.tableActingOn = tableActingOn;
        this.selections = toSelect.length == 0 ? "*" : "`" + String.join((CharSequence)"`, `", toSelect) + "`";
    }

    private String buildQuery() {
        String res = "SELECT " + this.selections + " FROM `" + this.tableActingOn + "`";
        if (this.searchColumns.size() != 0) {
            res = res + " WHERE `" + String.join((CharSequence)"` = ? AND `", this.searchColumns) + "` = ?";
        }
        return res + ";";
    }

    public SelectQuery whereEquals(String column, Object value) {
        this.searchColumns.add(column);
        this.searchValues.add(value);
        return this;
    }

    @Override
    public PreparedStatement getStatement() throws SQLException {
        PreparedStatement stmn = this.getConnection().prepareStatement(this.buildQuery());
        for (int i = 0; i < this.searchColumns.size(); ++i) {
            stmn.setObject(i + 1, this.searchValues.get(i));
        }
        return stmn;
    }
}

