/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import masecla.mlib.classes.sql.CreateTableQuery;
import masecla.mlib.classes.sql.DeleteQuery;
import masecla.mlib.classes.sql.InsertQuery;
import masecla.mlib.classes.sql.SelectQuery;
import masecla.mlib.classes.sql.UpdateQuery;

public class SQLConnection {
    private String host;
    private String port;
    private String user;
    private String pass;
    private String db;
    private Connection connection = null;

    public SQLConnection(String host, String port, String user, String pass, String db) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pass = pass;
        this.db = db;
    }

    public SQLConnection(String user, String pass, String db) {
        this("localhost", "3306", user, pass, db);
    }

    public void buildConnection() throws SQLException {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.db + "?useSSL=false";
        this.connection = DriverManager.getConnection(url, this.user, this.pass);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    public SelectQuery newSelectQuery(String table, String ... selections) {
        return new SelectQuery(this.connection, table, selections);
    }

    public InsertQuery newInsertQuery(String table) {
        return new InsertQuery(this.connection, table);
    }

    public UpdateQuery newUpdateQuery(String table) {
        return new UpdateQuery(this.connection, table);
    }

    public CreateTableQuery newCreateTableQuery(String table) {
        return new CreateTableQuery(this.connection, table);
    }

    public DeleteQuery newDeleteQuery(String table) {
        return new DeleteQuery(this.connection, table);
    }

    public Connection getConnection() {
        return this.connection;
    }
}

