/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import masecla.mlib.classes.sql.SQLQuery;

public class CreateTableQuery
extends SQLQuery {
    private String tableName;
    List<String> columns = new ArrayList<String>();
    List<String> primaryKeys = new ArrayList<String>();

    public CreateTableQuery(Connection connection, String tableName) {
        super(connection);
        this.tableName = tableName;
    }

    public String buildQuery() {
        return "CREATE TABLE IF NOT EXISTS `" + this.tableName + "` (" + String.join((CharSequence)", ", this.columns) + (this.primaryKeys.size() != 0 ? ", " : "") + String.join((CharSequence)", ", this.primaryKeys) + ")";
    }

    @Override
    public PreparedStatement getStatement() throws SQLException {
        return this.getConnection().prepareStatement(this.buildQuery());
    }

    public CreateTableQuery addIdKey() {
        this.columns.add("`id` INT NOT NULL AUTO_INCREMENT");
        this.primaryKeys.add("PRIMARY KEY (`id`)");
        return this;
    }

    public CreateTableQuery addInt(String columnName) {
        this.columns.add("`" + columnName + "` INT");
        return this;
    }

    public CreateTableQuery addLong(String columnName) {
        this.columns.add("`" + columnName + "` BIGINT");
        return this;
    }

    public CreateTableQuery addString(String columnName) {
        this.columns.add("`" + columnName + "` TEXT CHARACTER SET utf8 COLLATE utf8_bin");
        return this;
    }
}

