/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.messages;

import java.util.ArrayList;
import java.util.List;
import masecla.mlib.classes.MamlConfiguration;
import masecla.mlib.classes.Predicates;
import masecla.mlib.main.MLib;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SendableSound {
    private List<SoundTag> sounds = new ArrayList<SoundTag>();

    public SendableSound(MamlConfiguration at, String path) {
        if (!at.isSet(path)) {
            return;
        }
        for (String s : at.getKeys(true, Predicates.startsWith(path), Predicates.configPath(path.split("\\.").length + 1))) {
            this.sounds.add(new SoundTag(at, s));
        }
    }

    public List<SoundTag> getSounds() {
        return this.sounds;
    }

    public void setSounds(List<SoundTag> sounds) {
        this.sounds = sounds;
    }

    public void sendToPlayer(Player p) {
        this.sounds.forEach(c -> c.sendToPlayer(p));
    }

    public static class SoundTag {
        private MLib lib;
        private String name = "NONE";
        private float pitch = 1.0f;
        private float volume = 1.0f;
        private int delay = 0;

        public SoundTag(MamlConfiguration at, String path) {
            this.lib = at.getLib();
            if (!at.isSet(path + ".type")) {
                return;
            }
            this.name = at.getString(path + ".type");
            if (at.isSet(path + ".pitch")) {
                this.pitch = (float)at.getDouble(path);
            }
            if (at.isSet(path + ".volume")) {
                this.volume = (float)at.getDouble(path + ".volume");
            }
            if (at.isSet(path + ".delay")) {
                this.delay = at.getInt(path + ".delay");
            }
        }

        public void sendToPlayer(Player p) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.lib.getPlugin(), () -> {
                Sound toUse = null;
                for (Sound s : Sound.values()) {
                    if (!s.toString().equals(this.name)) continue;
                    toUse = s;
                }
                p.playSound(p.getLocation(), toUse, this.volume, this.pitch);
            }, (long)this.delay);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public float getPitch() {
            return this.pitch;
        }

        public void setPitch(float pitch) {
            this.pitch = pitch;
        }

        public float getVolume() {
            return this.volume;
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }
    }
}

