/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.messages;

import java.util.ArrayList;
import java.util.List;
import masecla.mlib.classes.MamlConfiguration;
import masecla.mlib.classes.Predicates;
import masecla.mlib.main.MLib;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SendableCommand {
    private List<CommandTag> commands = new ArrayList<CommandTag>();

    public SendableCommand(MamlConfiguration at, String path) {
        if (!at.isSet(path)) {
            return;
        }
        for (String s : at.getKeys(true, Predicates.startsWith(path), Predicates.configPath(path.split("\\.").length + 1))) {
            this.commands.add(new CommandTag(at, s));
        }
    }

    public List<CommandTag> getCommands() {
        return this.commands;
    }

    public void setCommands(List<CommandTag> commands) {
        this.commands = commands;
    }

    public void sendToPlayer(Player p) {
        this.commands.forEach(c -> c.sendToPlayer(p));
    }

    public static class CommandTag {
        private MLib lib;
        private String command = "";
        private String executor = "CONSOLE";
        private int delay = 0;

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getExecutor() {
            return this.executor;
        }

        public void setExecutor(String executor) {
            this.executor = executor;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delay) {
            this.delay = delay;
        }

        public CommandTag(MamlConfiguration at, String path) {
            this.lib = at.getLib();
            if (!at.isSet(path + ".command")) {
                return;
            }
            this.command = at.getString(path + ".command");
            if (at.isSet(path + ".executor")) {
                this.executor = at.getString(path + ".executor");
            }
            if (at.isSet(path + ".delay")) {
                this.delay = at.getInt(path + ".delay");
            }
        }

        public void sendToPlayer(Player p) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.lib.getPlugin(), () -> {
                ConsoleCommandSender dispatcher = this.executor.equalsIgnoreCase("CONSOLE") ? Bukkit.getConsoleSender() : Bukkit.getPlayer((String)this.executor.replace("%player%", p.getName()));
                Bukkit.dispatchCommand((CommandSender)dispatcher, (String)this.command.replace("%player%", p.getName()));
            }, (long)this.delay);
        }
    }
}

