/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.classes.messages;

import masecla.mlib.classes.MamlConfiguration;
import masecla.mlib.classes.Replaceable;
import masecla.mlib.classes.messages.SendableCommand;
import masecla.mlib.classes.messages.SendableMessage;
import masecla.mlib.classes.messages.SendableSound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MultiMessage {
    private SendableMessage message = null;
    private SendableSound sound = null;
    private SendableCommand command = null;

    public MultiMessage(MamlConfiguration config, String prefix, String atPath) {
        if (config.isSet(atPath + ".text")) {
            boolean centered = config.getBoolean(atPath + ".centered", false);
            this.message = new SendableMessage(config, atPath + ".text", prefix, centered);
            this.sound = new SendableSound(config, atPath + ".sounds");
            this.command = new SendableCommand(config, atPath + ".commands");
        } else {
            this.message = new SendableMessage(config, atPath, prefix);
        }
    }

    public void sendToPlayer(CommandSender sender, Replaceable ... repl) {
        if (sender instanceof Player) {
            Player receiver = (Player)sender;
            this.message.sendToPlayer((CommandSender)receiver, repl);
            if (this.sound != null) {
                this.sound.sendToPlayer(receiver);
            }
            if (this.command != null) {
                this.command.sendToPlayer(receiver);
            }
        } else {
            this.message.sendToPlayer(sender, repl);
        }
    }

    public SendableMessage getMessage() {
        return this.message;
    }

    public void setMessage(SendableMessage message) {
        this.message = message;
    }

    public SendableSound getSound() {
        return this.sound;
    }

    public void setSound(SendableSound sound) {
        this.sound = sound;
    }

    public SendableCommand getCommand() {
        return this.command;
    }

    public void setCommand(SendableCommand command) {
        this.command = command;
    }
}

