/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import masecla.mlib.apis.CompatibilityAPI;
import masecla.mlib.apis.NMSAPI;
import masecla.mlib.apis.PacketAPI;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class TitleAPI {
    private NMSAPI nmsapi;
    private PacketAPI packetapi;
    private CompatibilityAPI compatibilityApi;

    public void sendTitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String message) {
        this.sendTitle(player, fadeIn, stay, fadeOut, message, null);
    }

    public void sendSubtitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String message) {
        this.sendTitle(player, fadeIn, stay, fadeOut, null, message);
    }

    public void sendFullTitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String title, String subtitle) {
        this.sendTitle(player, fadeIn, stay, fadeOut, title, subtitle);
    }

    public void sendTitle(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String title, String subtitle) {
        if (this.compatibilityApi.getServerVersion().getMajor() < 12) {
            this.sendTitleOld(player, fadeIn, stay, fadeOut, title, subtitle);
        } else {
            if (title != null) {
                title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
            }
            if (subtitle != null) {
                subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
            }
            player.sendTitle(title, subtitle, fadeIn.intValue(), stay.intValue(), fadeOut.intValue());
        }
    }

    private void sendTitleOld(Player player, Integer fadeIn, Integer stay, Integer fadeOut, String title, String subtitle) {
        try {
            Class<?> packetClass = this.nmsapi.getNMSClass("PacketPlayOutTitle");
            Class<?> titleAction = this.nmsapi.getNMSClass("PacketPlayOutTitle$EnumTitleAction");
            Class<?> chatComponentClass = this.nmsapi.getNMSClass("IChatBaseComponent");
            Class<?> chatSerializerClass = this.nmsapi.getNMSClass("IChatBaseComponent$ChatSerializer");
            Method serializeMethod = chatSerializerClass.getMethod("a", String.class);
            Constructor<?> subtitleConstructor = packetClass.getConstructor(titleAction, chatComponentClass, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            Object enumTimes = titleAction.getField("TIMES").get(null);
            Object enumTitle = titleAction.getField("TITLE").get(null);
            Object enumSubtitle = titleAction.getField("SUBTITLE").get(null);
            if (title != null) {
                title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
                Object chatTitle = serializeMethod.invoke(null, "{\"text\":\"" + title + "\"}");
                Object titlePacket = subtitleConstructor.newInstance(enumTimes, chatTitle, fadeIn, stay, fadeOut);
                this.packetapi.sendPacket(player, titlePacket);
                chatTitle = serializeMethod.invoke(null, "{\"text\":\"" + title + "\"}");
                titlePacket = subtitleConstructor.newInstance(enumTitle, chatTitle, -1, -1, -1);
                this.packetapi.sendPacket(player, titlePacket);
            }
            if (subtitle != null) {
                subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle);
                Object chatSubtitle = serializeMethod.invoke(null, "{\"text\":\"" + title + "\"}");
                Object subtitlePacket = subtitleConstructor.newInstance(enumTimes, chatSubtitle, fadeIn, stay, fadeOut);
                this.packetapi.sendPacket(player, subtitlePacket);
                chatSubtitle = serializeMethod.invoke(null, "{\"text\":\"" + subtitle + "\"}");
                subtitlePacket = subtitleConstructor.newInstance(enumSubtitle, chatSubtitle, fadeIn, stay, fadeOut);
                this.packetapi.sendPacket(player, subtitlePacket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearTitle(Player player) {
        this.sendTitle(player, 0, 0, 0, "", "");
    }

    public TitleAPI(NMSAPI nmsapi, PacketAPI packetapi, CompatibilityAPI compatibilityApi) {
        this.nmsapi = nmsapi;
        this.packetapi = packetapi;
        this.compatibilityApi = compatibilityApi;
    }
}

