/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;

public class TimesAPI {
    private final long TICKS_MONTH = 51840000L;
    private final long TICKS_DAY = 1728000L;
    private final long TICKS_HOUR = 72000L;
    private final long TICKS_MINUTE = 1200L;

    public String generateTime(long secs) {
        if (secs == 0L) {
            return "0 seconds";
        }
        long months = (secs *= 20L) / 51840000L;
        long days = (secs %= 51840000L) / 1728000L;
        long hours = (secs %= 1728000L) / 72000L;
        long minutes = (secs %= 72000L) / 1200L;
        long seconds = (secs %= 1200L) / 20L;
        boolean somethingUsed = false;
        String result = "";
        if (months != 0L) {
            result = result + months + " " + this.singOrPl(months, "month", "months") + ", ";
            somethingUsed = true;
        }
        if (days != 0L) {
            result = result + days + " " + this.singOrPl(days, "day", "days") + ", ";
            somethingUsed = true;
        }
        if (hours != 0L) {
            result = result + hours + " " + this.singOrPl(hours, "hour", "hours") + ", ";
            somethingUsed = true;
        }
        if (minutes != 0L) {
            result = result + minutes + " " + this.singOrPl(minutes, "minute", "minutes");
            somethingUsed = true;
        }
        if (seconds != 0L) {
            result = somethingUsed ? result + " and " + seconds + " " + this.singOrPl(seconds, "second", "seconds") : result + seconds + " " + this.singOrPl(seconds, "second", "seconds");
        }
        return result.replace("  ", " ");
    }

    private String singOrPl(long qty, String singular, String plural) {
        if (qty == 1L) {
            return singular;
        }
        return plural;
    }

    public int timeToSeconds(String arg) {
        int currentTime = 0;
        String curr = "";
        try {
            for (int i = 0; i < arg.length(); ++i) {
                Character a = Character.valueOf(arg.charAt(i));
                if (Character.isLetter(a.charValue())) {
                    if (a.charValue() == 's') {
                        currentTime += Integer.parseInt(curr);
                    } else if (a.charValue() == 'm') {
                        currentTime += Integer.parseInt(curr) * 60;
                    } else if (a.charValue() == 'h') {
                        currentTime += Integer.parseInt(curr) * 3600;
                    } else if (a.charValue() == 'd') {
                        currentTime += Integer.parseInt(curr) * 86400;
                    } else if (a.charValue() == 'w') {
                        currentTime += Integer.parseInt(curr) * 604800;
                    }
                    curr = "";
                    continue;
                }
                curr = curr + a.toString();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return currentTime;
    }

    public String generateDateString() {
        Date dt = new Date(Instant.now().getEpochSecond() * 1000L);
        SimpleDateFormat frm = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        return frm.format(dt);
    }

    public String generateDateString(long milliseconds) {
        Date dt = new Date(milliseconds);
        SimpleDateFormat frm = new SimpleDateFormat("dd-MM-yyyy HH:mm");
        return frm.format(dt);
    }

    public long generateUnixTimestampFromDateString(String date) {
        try {
            return new SimpleDateFormat("dd-MM-yyyy HH:mm").parse(date).getTime();
        }
        catch (ParseException e) {
            return Instant.now().getEpochSecond() * 1000L;
        }
    }
}

