/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import masecla.mlib.apis.CompatibilityAPI;
import masecla.mlib.apis.NMSAPI;
import masecla.mlib.apis.PacketAPI;
import masecla.mlib.classes.Particle;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ParticleAPI {
    private CompatibilityAPI compapi;
    private PacketAPI packetapi;
    private NMSAPI nmsapi;
    private Constructor<?> particleConstructor = null;
    private Method spawnParticleMethod = null;
    private final int RADIUS = 900;

    public ParticleAPI(CompatibilityAPI compapi, PacketAPI packetapi, NMSAPI nmsapi) {
        this.compapi = compapi;
        this.packetapi = packetapi;
        this.nmsapi = nmsapi;
    }

    public void spawnParticle(World world, Particle particle, Location location, int count) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(world, particle, x, y, z, count, null);
    }

    public void spawnParticle(World world, Particle particle, Location location, int count, Object data) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count, Object data) {
        this.spawnParticle(world, particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(World world, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(world, particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public void spawnParticle(World world, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this.spawnParticle(world, particle, x, y, z, count, offsetX, offsetY, offsetZ, 0.0, data);
    }

    public void spawnParticle(World world, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, speed);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        this.spawnParticle(world, particle, x, y, z, count, offsetX, offsetY, offsetZ, speed, null);
    }

    public void spawnParticle(World world, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double speed, Object data) {
        this.spawnParticle(world, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, speed, data);
    }

    public void spawnParticle(World world, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double speed, Object data) {
        world.getPlayers().forEach(c -> this.spawnParticle((Player)c, particle, x, y, z, count, offsetX, offsetY, offsetZ, speed, data));
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(player, particle, x, y, z, count, null);
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count, Object data) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count, Object data) {
        this.spawnParticle(player, particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(player, particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, Object data) {
        this.spawnParticle(player, particle, x, y, z, count, offsetX, offsetY, offsetZ, 0.0, data);
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, speed);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double speed) {
        this.spawnParticle(player, particle, x, y, z, count, offsetX, offsetY, offsetZ, speed, null);
    }

    public void spawnParticle(Player player, Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double speed, Object data) {
        this.spawnParticle(player, particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, speed, data);
    }

    public void spawnParticle(Player player, Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double speed, Object data) {
        Location l = player.getLocation();
        double dx = l.getX() - x;
        double dy = l.getY() - y;
        double dz = l.getZ() - z;
        if ((dx *= dx) + (dy *= dy) + (dz *= dz) > 900.0) {
            return;
        }
        particle = this.ensureCompatibility(particle);
        try {
            if (this.compapi.getServerVersion().getMajor() == 8) {
                byte blockdata;
                int[] particleData = new int[]{};
                if (particle.equals((Object)Particle.BLOCK_CRACK)) {
                    int blockid = 0;
                    blockdata = 0;
                    if (data instanceof Block) {
                        blockid = ((Block)data).getTypeId();
                        blockdata = ((Block)data).getData();
                    } else if (data instanceof MaterialData) {
                        blockid = ((MaterialData)data).getItemTypeId();
                        blockdata = ((MaterialData)data).getData();
                    } else if (data instanceof BlockState) {
                        blockid = ((BlockState)data).getTypeId();
                        blockdata = ((BlockState)data).getRawData();
                    } else if (data instanceof Material) {
                        blockid = ((Material)data).getId();
                        blockdata = 0;
                    } else if (data instanceof ItemStack) {
                        blockid = ((ItemStack)data).getTypeId();
                        blockdata = ((ItemStack)data).getData().getData();
                    }
                    particleData = new int[]{blockdata << 12 | blockid & 0xFFF};
                } else if (particle.equals((Object)Particle.BLOCK_DUST)) {
                    if (data instanceof Material) {
                        Material m = (Material)data;
                        particleData = new int[]{m.getId()};
                    } else if (data instanceof Block) {
                        int blockid = ((Block)data).getTypeId();
                        blockdata = ((Block)data).getData();
                        particleData = new int[]{blockdata << 12 | blockid & 0xFFF};
                    } else if (data instanceof BlockState) {
                        int blockid = ((BlockState)data).getTypeId();
                        blockdata = ((BlockState)data).getRawData();
                        particleData = new int[]{blockdata << 12 | blockid & 0xFFF};
                    } else if (data instanceof MaterialData) {
                        int blockid = ((MaterialData)data).getItemTypeId();
                        blockdata = ((MaterialData)data).getData();
                        particleData = new int[]{blockdata << 12 | blockid & 0xFFF};
                    } else if (data instanceof ItemStack) {
                        int blockid = ((ItemStack)data).getTypeId();
                        blockdata = ((ItemStack)data).getData().getData();
                        particleData = new int[]{blockdata << 12 | blockid & 0xFFF};
                    }
                    if (particleData.length == 0) {
                        particleData = new int[]{0};
                    }
                } else if (particle.equals((Object)Particle.ITEM_CRACK)) {
                    if (data instanceof ItemStack) {
                        ItemStack m = (ItemStack)data;
                        if (m == null) {
                            m = new ItemStack(Material.STONE_PICKAXE);
                        }
                        particleData = new int[]{m.getData().getItemTypeId(), m.getData().getData()};
                    } else if (data instanceof Material) {
                        Material m = (Material)data;
                        particleData = new int[]{m.getId(), 0};
                    } else if (data instanceof MaterialData) {
                        int blockid = ((MaterialData)data).getItemTypeId();
                        blockdata = ((MaterialData)data).getData();
                        particleData = new int[]{blockid, blockdata};
                    } else if (data instanceof Block) {
                        int blockid = ((Block)data).getTypeId();
                        blockdata = ((Block)data).getData();
                        particleData = new int[]{blockid, blockdata};
                    } else if (data instanceof BlockState) {
                        int blockid = ((BlockState)data).getTypeId();
                        blockdata = ((BlockState)data).getRawData();
                        particleData = new int[]{blockid, blockdata};
                    }
                    if (particleData.length == 0) {
                        particleData = new int[]{0, 0};
                    }
                }
                Class<?> enumParticleClass = this.nmsapi.getNMSClass("EnumParticle");
                Object particleValue = Enum.valueOf(enumParticleClass, particle.toString());
                if (this.particleConstructor == null) {
                    this.particleConstructor = this.nmsapi.getNMSClass("PacketPlayOutWorldParticles").getConstructor(enumParticleClass, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class);
                }
                Object packet = this.particleConstructor.newInstance(particleValue, true, Float.valueOf((float)x), Float.valueOf((float)y), Float.valueOf((float)z), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)speed), count, particleData);
                this.packetapi.sendPacket(player, packet);
            } else if (this.compapi.getServerVersion().getMajor() > 9) {
                Class<?> particleBukkit = Class.forName("org.bukkit.Particle");
                Object particleValue = Enum.valueOf(particleBukkit, particle.toString());
                if (this.spawnParticleMethod == null) {
                    this.spawnParticleMethod = Player.class.getDeclaredMethod("spawnParticle", particleBukkit, Double.TYPE, Double.TYPE, Double.TYPE, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Object.class);
                }
                this.spawnParticleMethod.invoke((Object)player, particleValue, x, y, z, count, offsetX, offsetY, offsetZ, speed, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Particle ensureCompatibility(Particle particle) {
        int fbacks = 0;
        while (particle.getAvailableIn().getVernumber() > this.compapi.getServerVersion().getVernumber()) {
            particle = particle.getFallback();
            if (++fbacks <= 5) continue;
            break;
        }
        return particle;
    }

    public void circle(Location center, double radius, Particle particle, Player p) {
        double circumference = Math.PI * 2 * radius;
        int particleCount = (int)(circumference / 0.5);
        double step = Math.PI * 2 / (double)particleCount;
        double angle = 0.0;
        double x = center.getX();
        double z = center.getZ();
        int i = 0;
        while (i < particleCount) {
            double dx = Math.cos(angle) * radius;
            double dz = Math.sin(angle) * radius;
            this.spawnParticle(p, particle, x + dx, 0.0, z + dz, 1, 0.0, 0.0, 0.0, 0.0);
            ++i;
            angle += step;
        }
    }

    public void circle(Location center, double radius, Particle particle) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.circle(center, radius, particle, player);
        }
    }

    public void line(Location a, Location b, int steps, Particle prt, Player p) {
        double stp = steps;
        Location steppy = new Location(a.getWorld(), a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ());
        Location towork = b.clone();
        steppy.setX(steppy.getX() / stp);
        steppy.setY(steppy.getY() / stp);
        steppy.setZ(steppy.getZ() / stp);
        for (int i = 0; i < steps; ++i) {
            this.spawnParticle(p, prt, towork, 1, 0.0, 0.0, 0.0, 0.0);
            towork.setX(towork.getX() + steppy.getX());
            towork.setY(towork.getY() + steppy.getY());
            towork.setZ(towork.getZ() + steppy.getZ());
        }
    }

    public void line(Location a, Location b, int steps, Particle prt) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.line(a, b, steps, prt, player);
        }
    }

    public void line(Location a, Location b, Particle prt, Player p, double dapothemAmplifier) {
        double dx = Math.abs(a.getX() - b.getX());
        double dy = Math.abs(a.getY() - b.getY());
        double dz = Math.abs(a.getZ() - b.getZ());
        double dapothem = Math.sqrt(dx * dx + dy * dy + dz * dz);
        this.line(a, b, (int)(dapothem * dapothemAmplifier), prt, p);
    }

    public void line(Location a, Location b, Particle prt, double dapothemAmplifier) {
        double dx = Math.abs(a.getX() - b.getX());
        double dy = Math.abs(a.getY() - b.getY());
        double dz = Math.abs(a.getZ() - b.getZ());
        double dapothem = Math.sqrt(dx * dx + dy * dy + dz * dz);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.line(a, b, (int)(dapothem * dapothemAmplifier), prt, player);
        }
    }

    public void cube(Location a, Location b, Particle eff, double offset, Player p) {
        Location min = new Location(a.getWorld(), Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()));
        Location max = new Location(a.getWorld(), Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()));
        max = max.add(offset, offset, offset);
        min = min.add(-offset, -offset, -offset);
        int xsteps = Math.abs(min.getBlockX() - max.getBlockX()) * 3;
        int ysteps = Math.abs(min.getBlockY() - max.getBlockY()) * 3;
        int zsteps = Math.abs(min.getBlockZ() - max.getBlockZ()) * 3;
        Location p1 = min.clone();
        Location p2 = min.clone();
        Location p3 = min.clone();
        Location p4 = min.clone();
        p2.setX(max.getX());
        p3.setZ(max.getZ());
        p4.setX(max.getX());
        p4.setZ(max.getZ());
        Location p5 = max.clone();
        Location p6 = max.clone();
        Location p7 = max.clone();
        Location p8 = max.clone();
        p6.setX(min.getX());
        p7.setZ(min.getZ());
        p8.setX(min.getX());
        p8.setZ(min.getZ());
        this.line(p1, p2, xsteps, eff, p);
        this.line(p1, p3, zsteps, eff, p);
        this.line(p3, p4, xsteps, eff, p);
        this.line(p2, p4, zsteps, eff, p);
        this.line(p1, p8, ysteps, eff, p);
        this.line(p2, p7, ysteps, eff, p);
        this.line(p3, p6, ysteps, eff, p);
        this.line(p4, p5, ysteps, eff, p);
        this.line(p5, p6, xsteps, eff, p);
        this.line(p5, p7, zsteps, eff, p);
        this.line(p6, p8, zsteps, eff, p);
        this.line(p7, p8, xsteps, eff, p);
    }

    public void cube(Location a, Location b, Particle prt, double offset) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.cube(a, b, prt, offset, player);
        }
    }

    public void cube(Location a, Location b, Particle prt) {
        this.cube(a, b, prt, 0.2);
    }

    public void cube(Location a, Location b, Particle prt, Player p) {
        this.cube(a, b, prt, 0.2, p);
    }
}

