/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import masecla.mlib.apis.LoggerAPI;
import masecla.mlib.classes.MamlConfiguration;
import masecla.mlib.classes.Pair;
import masecla.mlib.classes.Replaceable;
import masecla.mlib.classes.messages.MultiMessage;
import masecla.mlib.main.MLib;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MessagesAPI {
    private MamlConfiguration cnf = null;
    private Map<Pair<String, String>, Long> lastTimeMessages = new HashMap<Pair<String, String>, Long>();
    private MLib lib;
    private LoggerAPI logapi;
    private JavaPlugin pl;
    private boolean antispamEnabled = true;
    private Map<String, Long> antispamDelays = new HashMap<String, Long>();

    public MessagesAPI(LoggerAPI logapi, JavaPlugin pl, MLib lib) {
        this.logapi = logapi;
        this.pl = pl;
        this.lib = lib;
        this.updateNewConfig();
    }

    private Map<String, Object> getMessagesFrom(ConfigurationSection sect) {
        HashMap<String, Object> gt = new HashMap<String, Object>();
        for (String s : sect.getKeys(false)) {
            gt.put(s, sect.get(s));
        }
        return gt;
    }

    public List<String> getPluginListMessage(String message, OfflinePlayer p, Replaceable ... replaces) {
        MultiMessage msg = new MultiMessage(this.getSharedConfig(), "", "messages." + this.pl.getName() + ".messages." + message);
        return msg.getMessage().getMessages(p, replaces);
    }

    public List<String> getPluginListMessage(String message, Replaceable ... replaces) {
        return this.getPluginListMessage(message, (OfflinePlayer)null, replaces);
    }

    public String getPluginMessage(String message, boolean prefix, Player p, Replaceable ... replaces) {
        MultiMessage msg = new MultiMessage(this.getSharedConfig(), prefix ? this.getPluginPrefix() : "", "messages." + this.pl.getName() + ".messages." + message);
        if (!this.getSharedConfig().isSet("messages." + this.pl.getName() + ".messages." + message)) {
            this.lib.getLoggerAPI().warn("Invalid message " + message + " was called.");
            return "";
        }
        return msg.getMessage().getMessagesAsString(p, replaces);
    }

    public String getPluginMessage(String message, boolean prefix, Replaceable ... replaces) {
        return this.getPluginMessage(message, prefix, (Player)null, replaces);
    }

    public String getPluginMessage(String message, Player p, Replaceable ... rpl) {
        return this.getPluginMessage(message, false, p, rpl);
    }

    public String getPluginMessage(String message, Replaceable ... replaces) {
        return this.getPluginMessage(message, false, (Player)null, replaces);
    }

    public String getPluginPrefix() {
        try {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)this.getSharedConfig().getString("messages." + this.pl.getName() + ".prefix").replace("\\n", "\n"));
        }
        catch (Exception e) {
            return "";
        }
    }

    public MamlConfiguration getSharedConfig() {
        if (this.cnf == null) {
            File fakeConfig;
            File actualConfig;
            this.cnf = new MamlConfiguration(this.lib);
            File parent = new File(this.pl.getDataFolder().getParent() + File.separator + "MLib");
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (!(actualConfig = new File(parent.getAbsolutePath() + File.separator + "messages.yml")).exists()) {
                try {
                    actualConfig.createNewFile();
                    this.logapi.information("Created the messages file!", true);
                }
                catch (IOException e) {
                    this.logapi.information("Crashed while making the exception file!", true);
                }
            }
            if (!(fakeConfig = new File(this.pl.getDataFolder(), "messages.yml")).exists()) {
                try {
                    fakeConfig.createNewFile();
                    FileOutputStream fos = new FileOutputStream(fakeConfig);
                    fos.write("# Messages are stored in plugins/MLib/messages.yml".getBytes());
                    fos.close();
                    this.logapi.information("Created the messages file!", true);
                }
                catch (IOException e) {
                    this.logapi.information("Crashed while making the fake messages file!", true);
                }
            }
            this.cnf.load(actualConfig);
            return this.cnf;
        }
        return this.cnf;
    }

    public void reloadSharedConfig() {
        String path = this.pl.getDataFolder().getParentFile().getAbsolutePath() + File.separator + "MLib" + File.separator + "messages.yml";
        this.cnf.load(new File(path));
    }

    private void saveSharedConfig() {
        String path = this.pl.getDataFolder().getParentFile().getAbsolutePath() + File.separator + "MLib" + File.separator + "messages.yml";
        if (this.cnf == null) {
            this.logapi.error("Somehow the MamlConfiguration object was null upon saving?", true);
        }
        this.cnf.save(new File(path));
    }

    public void sendActionbarMessage(String message, CommandSender sender) {
        if (sender == null || message == null) {
            return;
        }
        if (!(sender instanceof Player)) {
            return;
        }
        Player player = (Player)sender;
        String nmsVersion = this.lib.getCompatibilityApi().getNMSVersion();
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        if (this.lib.getCompatibilityApi().getServerVersion().getMajor() > 9) {
            try {
                Player.Spigot psp = player.spigot();
                Method mtd = Player.Spigot.class.getMethod("sendMessage", ChatMessageType.class, BaseComponent[].class);
                mtd.invoke((Object)psp, ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        try {
            Class<?> ppoc = this.lib.getNmsAPI().getNMSClass("PacketPlayOutChat");
            Class<?> chatBaseComponent = this.lib.getNmsAPI().getNMSClass("IChatBaseComponent");
            Object object = null;
            if (nmsVersion.startsWith("v1_8_R")) {
                Class<?> serializerClass = this.lib.getNmsAPI().getNMSClass("IChatBaseComponent$ChatSerializer");
                Method method = serializerClass.getDeclaredMethod("a", String.class);
                object = method.invoke(serializerClass, "{'text': '" + message + "'}");
            } else {
                Class<?> componentClass = this.lib.getNmsAPI().getNMSClass("ChatComponentText");
                object = componentClass.getConstructor(String.class).newInstance(message);
            }
            Object packetPlayOutChat = ppoc.getConstructor(chatBaseComponent, Byte.TYPE).newInstance(object, (byte)2);
            this.lib.getPacketAPI().sendPacket(player, packetPlayOutChat);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendMessage(String message, CommandSender player, Replaceable ... replaces) {
        this.sendMessage(message, player, true, replaces);
    }

    public void sendMessage(String message, CommandSender player, boolean prefix, Replaceable ... replaces) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.pl, () -> this.sendMessage(message, player, prefix, replaces), 0L);
            return;
        }
        String uuid = player instanceof Player ? ((Player)player).getUniqueId().toString() : "CONSOLE";
        Pair<String, String> toPut = new Pair<String, String>(uuid, message);
        if (System.currentTimeMillis() - this.lastTimeMessages.getOrDefault(toPut, 0L) < this.getAntispamDelay(message)) {
            return;
        }
        this.lastTimeMessages.put(toPut, System.currentTimeMillis());
        if (this.lastTimeMessages.size() > 100) {
            this.lastTimeMessages.clear();
        }
        String messagePrefix = prefix ? this.getPluginPrefix() : "";
        MultiMessage msg = new MultiMessage(this.getSharedConfig(), messagePrefix, "messages." + this.pl.getName() + ".messages." + message);
        msg.sendToPlayer(player, replaces);
    }

    public Map<String, Long> getAntispamDelays() {
        return this.antispamDelays;
    }

    public void setAntispamDelay(String message, long delay) {
        this.antispamDelays.put(message, delay);
    }

    public long getAntispamDelay(String message) {
        if (!this.antispamEnabled) {
            return 0L;
        }
        return this.antispamDelays.getOrDefault(message, 1000L);
    }

    public void disableAntispam() {
        this.antispamEnabled = false;
    }

    private void updateNewConfig() {
        this.logapi.information("Searching for newest config!", true);
        InputStream str = this.pl.getResource("messages.yml");
        if (str == null) {
            this.logapi.error("Internal config doesn't exist?", true);
            return;
        }
        MamlConfiguration internal = new MamlConfiguration(this.lib);
        try {
            internal.load(new InputStreamReader(str));
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.logapi.information("Loaded internal config file!", true);
        String prefix = internal.getString("prefix");
        Map<String, Object> currentMsgs = null;
        try {
            currentMsgs = this.getMessagesFrom(internal.getConfig().getConfigurationSection("messages.plugin"));
        }
        catch (NullPointerException e) {
            this.logapi.warn("I could not fetch messages.plugin section from plugin! Fix your config schema! ", true);
        }
        if (currentMsgs == null) {
            this.logapi.warn("I could not fetch messages.plugin section from plugin! Fix your config schema! ", true);
            return;
        }
        File oldConfig = new File(this.pl.getDataFolder().getAbsolutePath() + File.separator + "messages.yml");
        if (oldConfig.exists() && oldConfig.length() > 500L) {
            this.logapi.information("Migrating old messages.yml file! Creating backup at messages.yml.backup");
            MamlConfiguration oldCnf = new MamlConfiguration(this.lib);
            oldCnf.load(oldConfig);
            String overrideablePrefix = oldCnf.getConfig().getString("prefix", null);
            ConfigurationSection sc = oldCnf.getConfig().getConfigurationSection("messages.plugin");
            Map<String, Object> oldMsgs = this.getMessagesFrom(sc);
            currentMsgs.putAll(oldMsgs);
            if (overrideablePrefix != null) {
                prefix = overrideablePrefix;
            }
            try {
                Files.move(oldConfig.toPath(), new File(oldConfig.getAbsolutePath() + ".backup").toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.logapi.information("Something went wrong while renaming the old config!", true);
            }
            oldConfig.delete();
        }
        if (!this.getSharedConfig().getConfig().isSet("messages." + this.pl.getName() + ".prefix")) {
            this.getSharedConfig().getConfig().set("messages." + this.pl.getName() + ".prefix", (Object)prefix);
            this.logapi.information("Created the shared config for " + this.pl.getName() + "! Watch for MLib/messages.yml");
        }
        int cr = 0;
        for (String s : currentMsgs.keySet()) {
            if (this.getSharedConfig().getConfig().isSet("messages." + this.pl.getName() + ".messages." + s)) continue;
            Object toSet = currentMsgs.get(s);
            if (toSet instanceof String) {
                String c2 = (String)toSet;
                c2 = c2.replace("\n", "\\n");
                toSet = c2;
            }
            if (toSet instanceof List) {
                List st = (List)toSet;
                st.forEach(c -> {
                    c = c.replace("\n", "\\n");
                });
                toSet = st;
            }
            this.getSharedConfig().getConfig().set("messages." + this.pl.getName() + ".messages." + s, toSet);
            ++cr;
        }
        this.logapi.information("Updated " + cr + " messages!", true);
        this.saveSharedConfig();
    }
}

