/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import masecla.mlib.apis.InventoryAPI;
import masecla.mlib.apis.LoggerAPI;
import masecla.mlib.apis.MathAPI;
import masecla.mlib.containers.generic.GenericContainer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ContainerAPI {
    private LoggerAPI logapi;
    private JavaPlugin plugin;
    private InventoryAPI invapi;
    private List<GenericContainer> registeredContainers = new ArrayList<GenericContainer>();
    private HashMap<UUID, Class<? extends GenericContainer>> currentlyOpen = new HashMap();
    private boolean registered = false;

    public ContainerAPI(JavaPlugin plugin, MathAPI mapi, LoggerAPI logapi, InventoryAPI invapi) {
        this.logapi = logapi;
        this.plugin = plugin;
        this.invapi = invapi;
        this.registered = false;
    }

    private void registerListeners() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        this.plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onClose(InventoryCloseEvent ev) {
                UUID playerId = ev.getPlayer().getUniqueId();
                if (ContainerAPI.this.currentlyOpen.containsKey(playerId)) {
                    ContainerAPI.this.getInstanceFor((Class)ContainerAPI.this.currentlyOpen.get(playerId)).closeFor(ev);
                    ContainerAPI.this.currentlyOpen.remove(playerId);
                }
            }

            @EventHandler
            public void onDrop(PlayerDropItemEvent ev) {
                UUID playerId = ev.getPlayer().getUniqueId();
                if (ContainerAPI.this.currentlyOpen.containsKey(playerId)) {
                    ContainerAPI.this.getInstanceFor((Class)ContainerAPI.this.currentlyOpen.get(playerId)).onDrop(ev);
                    ContainerAPI.this.updateInventory(ContainerAPI.this.getInstanceFor((Class)ContainerAPI.this.currentlyOpen.get(playerId)), true);
                }
            }

            @EventHandler
            public void onClick(InventoryClickEvent event) {
                Player player = (Player)event.getWhoClicked();
                if (ContainerAPI.this.currentlyOpen.containsKey(player.getUniqueId())) {
                    int clickedSlot = event.getRawSlot();
                    GenericContainer containerInstance = ContainerAPI.this.getInstanceFor((Class)ContainerAPI.this.currentlyOpen.get(player.getUniqueId()));
                    if (clickedSlot >= 0 && clickedSlot < containerInstance.getSize(player) && clickedSlot == event.getSlot() && event.getClickedInventory().getType().equals((Object)InventoryType.CHEST)) {
                        containerInstance.onTopClick(event);
                    } else if (clickedSlot != -999) {
                        containerInstance.onBottomClick(event);
                    }
                    if (clickedSlot != -999) {
                        ContainerAPI.this.updateInventory(containerInstance, true);
                    }
                }
            }

            @EventHandler
            public void onDrag(InventoryDragEvent event) {
                UUID playerId = event.getWhoClicked().getUniqueId();
                if (ContainerAPI.this.currentlyOpen.containsKey(playerId)) {
                    GenericContainer containerInstance = ContainerAPI.this.getInstanceFor((Class)ContainerAPI.this.currentlyOpen.get(playerId));
                    containerInstance.onDrag(event);
                    ContainerAPI.this.updateInventory(containerInstance, true);
                }
            }
        }, (Plugin)this.plugin);
    }

    @Deprecated
    public void registerContainer(GenericContainer instance) {
        this.registerListeners();
        this.registeredContainers.add(instance);
        this.logapi.information("Successfully registered " + instance.getClass().getName(), true);
        if (instance.requiresUpdating()) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> this.updateInventory(instance, false), 0L, (long)instance.getUpdatingInterval());
        }
    }

    private void updateInventory(GenericContainer cont, boolean fromClick) {
        if (cont == null) {
            return;
        }
        if (fromClick && !cont.updateOnClick()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (UUID players : cont.getOpenedFor()) {
            Player player = Bukkit.getPlayer((UUID)players);
            if (player == null) {
                toRemove.add(players);
                continue;
            }
            Inventory inv = cont.getInventory(player);
            if (inv == null) continue;
            this.invapi.updateInventoryView(player.getOpenInventory(), inv);
        }
        cont.getOpenedFor().removeAll(toRemove);
    }

    public void openFor(Player p, Class<? extends GenericContainer> container) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.openFor(p, container, 1), 1L);
    }

    public void openFor(Player p, Class<? extends GenericContainer> container, int layer) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.openFor(p, container));
            return;
        }
        if (this.currentlyOpen.containsKey(p.getUniqueId())) {
            this.getInstanceFor(this.currentlyOpen.get(p.getUniqueId())).closeFor(new InventoryCloseEvent(p.getOpenInventory()));
            this.currentlyOpen.remove(p.getUniqueId());
        }
        this.getInstanceFor(container).openFor(p);
        p.openInventory(this.getInstanceFor(container).getInventory(p));
        this.currentlyOpen.put(p.getUniqueId(), container);
    }

    public void closeFor(Player p) {
        p.closeInventory();
    }

    public GenericContainer getInstanceFor(Class<? extends GenericContainer> container) {
        for (GenericContainer c : this.registeredContainers) {
            if (!c.getClass().equals(container)) continue;
            return c;
        }
        return null;
    }
}

