/*
 * Decompiled with CFR 0.152.
 */
package masecla.mlib.apis;

import org.bukkit.Bukkit;

public class CompatibilityAPI {
    private String version = null;

    public String getNMSVersion() {
        if (this.version == null) {
            this.version = Bukkit.getServer().getClass().getPackage().getName();
            this.version = this.version.substring(this.version.lastIndexOf(46) + 1);
        }
        return this.version;
    }

    public Versions getServerVersion() {
        return Versions.matchVersion(this.getNMSVersion());
    }

    public static enum Versions {
        v1_8(0, "v1_8_R1", 8, 0),
        v1_8_3(1, "v1_8_R2", 8, 3),
        v1_8_8(2, "v1_8_R3", 8, 8),
        v1_9_2(3, "v1_9_R1", 9, 2),
        v1_9_4(4, "v1_9_R2", 9, 4),
        v1_10_2(5, "v1_10_R1", 10, 2),
        v1_11_2(6, "v1_11_R1", 11, 2),
        v1_12_2(7, "v1_12_R1", 12, 2),
        v1_13(8, "v1_13_R1", 13, 0),
        v1_13_2(9, "v1_13_R2", 13, 2),
        v1_14_4(10, "v1_14_R1", 14, 4),
        v1_15(11, "v1_15_R1", 15, 0),
        v1_16_1(12, "v1_16_R1", 16, 1),
        v1_16_3(13, "v1_16_R2", 16, 3),
        v1_16_4(14, "v1_16_R3", 16, 4),
        v1_17(15, "v1_17_R1", 17, 0),
        v1_18(16, "v1_18_R1", 18, 0),
        v1_18_2(17, "v1_18_R2", 18, 2),
        v1_19(18, "v1_19_R1", 19, 0),
        v1_19_3(19, "v1_19_R2", 19, 3),
        v1_19_4(20, "v1_19_R3", 19, 4);

        int vernumber;
        String nmsVersion;
        private int bigMajor;
        private int major;
        private int minor;

        private Versions(int vernumber, String nmsVersion, int bigMajor, int major, int minor) {
            this.vernumber = vernumber;
            this.nmsVersion = nmsVersion;
            this.bigMajor = bigMajor;
            this.major = major;
            this.minor = minor;
        }

        private Versions(int vernumber, String nmsVersion, int major, int minor) {
            this(vernumber, nmsVersion, 1, major, minor);
        }

        public int getVernumber() {
            return this.vernumber;
        }

        public int getBigMajor() {
            return this.bigMajor;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public String getNMSVersion() {
            return this.nmsVersion;
        }

        public static Versions matchVersion(String ver) {
            for (Versions x : Versions.values()) {
                if (!x.getNMSVersion().equals(ver)) continue;
                return x;
            }
            return v1_8;
        }

        public boolean supportsParticles() {
            return this.vernumber >= 7;
        }

        public boolean lowerThanOr(Versions version) {
            return this.vernumber <= version.vernumber;
        }

        public boolean higherThanOr(Versions version) {
            return this.vernumber >= version.vernumber;
        }
    }
}

