/*
 * Decompiled with CFR 0.152.
 */
package gunging.ootilities.mmoitem_shrubs;

import gunging.ootilities.gunging_ootilities_plugin.Gunging_Ootilities_Plugin;
import gunging.ootilities.gunging_ootilities_plugin.OotilityCeption;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub_Conditions;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub_Manager;
import io.lumine.mythic.lib.api.item.ItemTag;
import net.Indyuce.mmoitems.api.item.build.ItemStackBuilder;
import net.Indyuce.mmoitems.gui.edition.EditionInventory;
import net.Indyuce.mmoitems.stat.data.type.StatData;
import net.Indyuce.mmoitems.stat.type.ItemStat;
import net.Indyuce.mmoitems.stat.type.StringStat;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ShrubStat
extends StringStat {
    public ShrubStat() {
        super("GOOP_SHRUB_TYPE", Material.OAK_LEAVES, "Shrub Type", new String[]{"What shrub type this block is.", "", "\u00a7cMust be a placeable block."}, new String[]{"miscellaneous", "consumable"}, new Material[0]);
    }

    public void whenApplied(ItemStackBuilder item, StatData data) {
        String condT;
        String shrubType = data.toString().replace("-", "_").replace(" ", "_");
        Validate.isTrue((boolean)MMOItem_Shrub_Manager.IsShrubLoaded(shrubType), (String)("\u00a77There is no loaded Shrub Type '\u00a73" + shrubType + "\u00a77'"));
        MMOItem_Shrub shrub = MMOItem_Shrub_Manager.GetShrub(shrubType);
        item.addItemTag(new ItemTag[]{new ItemTag("MMOITEMS_GOOP_SHRUB_TYPE", (Object)shrubType)});
        Validate.isTrue((shrub.mmoitem_Generated != null ? 1 : 0) != 0, (String)("\u00a77Shrub type '\u00a73" + shrubType + "\u00a77' does not produce a valid MMOItem"));
        String path = "goop-shrub-type";
        item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", shrub.getName()).replace("$PRODUCE$", OotilityCeption.GetItemName((ItemStack)shrub.mmoitem_Generated))});
        path = "goop-shrub-gen-time";
        item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", OotilityCeption.NicestTimeValueFrom((Double)shrub.getMinimumGenerationTime()))});
        path = "goop-shrub-gen-chance";
        item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.getGenerationChance()))});
        boolean weatherRet = false;
        boolean daytimeRet = false;
        boolean altitudeRet = false;
        boolean dimensionalRet = false;
        boolean adventureRet = false;
        boolean cappedRet = false;
        boolean hasCap = false;
        boolean hasRain = false;
        boolean hasSunny = false;
        boolean hasThunder = false;
        boolean hasDay = false;
        boolean hasNight = false;
        boolean hasDawn = false;
        boolean hasSunset = false;
        boolean hasCavern = false;
        boolean hasUnderground = false;
        boolean hasSurface = false;
        boolean hasSky = false;
        boolean hasSpace = false;
        boolean hasOverworld = false;
        boolean hasNether = false;
        boolean hasEnd = false;
        boolean hasNearlands = false;
        boolean hasFarlands = false;
        boolean hasMediumlands = false;
        for (MMOItem_Shrub_Conditions cond : shrub.getConditions()) {
            switch (cond) {
                case UNCAPPED: {
                    hasCap = true;
                    cappedRet = true;
                    break;
                }
                case RAIN: {
                    hasRain = true;
                    weatherRet = true;
                    break;
                }
                case THUNDER: {
                    hasThunder = true;
                    weatherRet = true;
                    break;
                }
                case SUNNY: {
                    hasSunny = true;
                    weatherRet = true;
                    break;
                }
                case DAY: {
                    hasDay = true;
                    daytimeRet = true;
                    break;
                }
                case NIGHT: {
                    hasNight = true;
                    daytimeRet = true;
                    break;
                }
                case SUNSET: {
                    hasSunset = true;
                    daytimeRet = true;
                    break;
                }
                case DAWN: {
                    hasDawn = true;
                    daytimeRet = true;
                    break;
                }
                case CAVERN: {
                    hasCavern = true;
                    altitudeRet = true;
                    break;
                }
                case UNDERGROUND: {
                    hasUnderground = true;
                    altitudeRet = true;
                    break;
                }
                case SURFACE: {
                    hasSurface = true;
                    altitudeRet = true;
                    break;
                }
                case SKY: {
                    hasSky = true;
                    altitudeRet = true;
                    break;
                }
                case SPACE: {
                    hasSpace = true;
                    altitudeRet = true;
                    break;
                }
                case OVERWORLD: {
                    hasOverworld = true;
                    dimensionalRet = true;
                    break;
                }
                case NETHER: {
                    hasNether = true;
                    dimensionalRet = true;
                    break;
                }
                case END: {
                    hasEnd = true;
                    dimensionalRet = true;
                    break;
                }
                case NEARLANDS: {
                    hasNearlands = true;
                    adventureRet = true;
                    break;
                }
                case MEDIUMLANDS: {
                    hasMediumlands = true;
                    adventureRet = true;
                    break;
                }
                case FARLANDS: {
                    hasFarlands = true;
                    adventureRet = true;
                }
            }
        }
        if (weatherRet && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-weather"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#r", (String)"Rainy", (boolean)hasRain);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#t", (String)"Thunderstormy", (boolean)hasThunder);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#s", (String)"Sunny", (boolean)hasSunny);
            item.getLore().insert(path, new String[]{condT});
        }
        if (daytimeRet && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-daytime"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#d", (String)"Day", (boolean)hasDay);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#n", (String)"Night", (boolean)hasNight);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#sr", (String)"Sunrise", (boolean)hasDawn);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#ss", (String)"Sunset", (boolean)hasSunset);
            item.getLore().insert(path, new String[]{condT});
        }
        if (altitudeRet && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-altitude"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#c", (String)"Cavern", (boolean)hasCavern);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#u", (String)"Underground", (boolean)hasUnderground);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#su", (String)"Surface", (boolean)hasSurface);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#sk", (String)"Sky", (boolean)hasSky);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#sp", (String)"Space", (boolean)hasSpace);
            item.getLore().insert(path, new String[]{condT});
        }
        if (dimensionalRet && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-dimension"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#o", (String)"Overworld", (boolean)hasOverworld);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#n", (String)"Nether", (boolean)hasNether);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#e", (String)"End", (boolean)hasEnd);
            item.getLore().insert(path, new String[]{condT});
        }
        if (adventureRet && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-adventure"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#f", (String)"Farlands", (boolean)hasFarlands);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#m", (String)"Midlands", (boolean)hasMediumlands);
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#n", (String)"Origin Lands", (boolean)hasNearlands);
            item.getLore().insert(path, new String[]{condT});
        }
        if ((cappedRet || shrub.HarvestReset()) && (condT = ItemStat.translate((String)(path = "goop-shrub-cond-capacity"))) != null) {
            condT = OotilityCeption.ModulusReplace((String)condT, (String)"#c", (String)String.valueOf(shrub.getMaxCapacity()), (hasCap || shrub.HarvestReset() ? 1 : 0) != 0);
            item.getLore().insert(path, new String[]{condT});
        }
        if (shrub.HasAutodropChance()) {
            path = "goop-shrub-drops";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.GetAutodropChance() * 100.0))});
        }
        if (shrub.GetShookableFiltersName() != null) {
            path = "goop-shrub-tool";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.GetShookableFiltersName()))});
        }
        if (shrub.GetMaxResources() != null) {
            path = "goop-shrub-gen-max";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.GetMaxResources()))});
        }
        path = "goop-shrub-gen-cap";
        item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.GetMaxCapacity()))});
        if (shrub.GetSimultaneousGen() > 1) {
            path = "goop-shrub-gen-sim";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.GetSimultaneousGen()))});
        }
        if (shrub.IsPistonFarmable()) {
            path = "goop-shrub-pistons";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", String.valueOf(shrub.IsPistonFarmable()))});
        }
        if (shrub.GetFertilizerEfficiency() < 1.0) {
            path = "goop-shrub-fertilizer";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", OotilityCeption.ReadableRounding((Double)((1.0 - shrub.GetFertilizerEfficiency()) * 100.0), (Integer)0))});
        }
        if (shrub.IsTree()) {
            path = "goop-shrub-tree";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", OotilityCeption.ReadableRounding((Double)(shrub.GetLeavesConcentration() * 100.0), (Integer)0))});
        }
        if (shrub.IsSeeds() && shrub.GetSeedsMask().HasDisplayName()) {
            path = "goop-shrub-seeds";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", shrub.GetSeedsMask().getDisplayName())});
        }
        if (Gunging_Ootilities_Plugin.foundVault.booleanValue() && shrub.HasVaultCost()) {
            path = "goop-shrub-vault-cost";
            item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", OotilityCeption.ReadableRounding((Double)shrub.getVaultCost(), (Integer)2))});
            if (shrub.HasVaultRevenue()) {
                path = "goop-shrub-vault-revenue";
                item.getLore().insert(path, new String[]{ItemStat.translate((String)path).replace("#", OotilityCeption.ReadableRounding((Double)(shrub.getVaultRevenue() * 100.0), (Integer)1))});
            }
        }
    }

    public void whenInput(EditionInventory inv, String message, Object ... info) {
        String shrubType = message.replace(" ", "_").replace("-", "_");
        if (!MMOItem_Shrub_Manager.IsShrubLoaded(shrubType)) {
            inv.getPlayer().sendMessage("\u00a73[\u00a7eMMOItem Shrubs\u00a73] \u00a7cThere is no loaded shrub type '\u00a73" + shrubType + "\u00a7c'");
        } else {
            inv.getEditedSection().set(this.getPath(), (Object)shrubType);
            inv.registerTemplateEdition();
            inv.getPlayer().sendMessage("\u00a73[\u00a7eMMOItem Shrubs\u00a73] \u00a77Shrub type successfully changed to '\u00a73" + shrubType + "\u00a77'");
        }
    }
}

