/*
 * Decompiled with CFR 0.152.
 */
package gunging.ootilities.mmoitem_shrubs;

import gunging.ootilities.gunging_ootilities_plugin.Gunging_Ootilities_Plugin;
import gunging.ootilities.gunging_ootilities_plugin.OotilityCeption;
import gunging.ootilities.gunging_ootilities_plugin.compatibilities.GooPMMOItems;
import gunging.ootilities.gunging_ootilities_plugin.compatibilities.GooPVault;
import gunging.ootilities.gunging_ootilities_plugin.misc.OptimizedTimeFormat;
import gunging.ootilities.gunging_ootilities_plugin.misc.PlusMinusPercent;
import gunging.ootilities.mmoitem_shrubs.AlternativeTypes;
import gunging.ootilities.mmoitem_shrubs.ExtraneousArmorStand;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub_Conditions;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrub_Manager;
import gunging.ootilities.mmoitem_shrubs.MMOItem_Shrubs;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class MMOItem_Shrub_Instance {
    public String mmoitem_type_origin;
    public String mmoitem_id_origin;
    public long internalID;
    public MMOItem_Shrub parent;
    public Location location;
    public ArmorStand display;
    public String displayUUID;
    public UUID ownerUUID;
    public OfflinePlayer owner;
    public OptimizedTimeFormat lastGenerationDate;
    public double fertilizerMultiplier = 1.0;
    boolean chunkLoaded = false;
    public OptimizedTimeFormat lastTimeConditionsNotMet;
    Material nativeMat;
    public int generations;
    public int currentCount;
    public int chunkX;
    public int chunkZ;
    public static int cavernEdge = 25;
    public static int underEdge = 50;
    public static int surfaceEdge = 175;
    public static int skyEdge = 225;
    public static long nearEdge = 2000L;
    public static long farEdge = 50000L;
    boolean markForDestruction;
    boolean destroyed = false;
    boolean basePoseRegeneration = false;

    public MMOItem_Shrub getParent() {
        if (this.parent.markedForOblivion && MMOItem_Shrub_Manager.loadedShrubLink.containsKey(this.parent.getName())) {
            this.parent = MMOItem_Shrub_Manager.loadedShrubLink.get(this.parent.getName());
        }
        return this.parent;
    }

    public MMOItem_Shrub GetParent() {
        if (this.parent.markedForOblivion && MMOItem_Shrub_Manager.loadedShrubLink.containsKey(this.parent.getName())) {
            this.parent = MMOItem_Shrub_Manager.loadedShrubLink.get(this.parent.getName());
        }
        return this.parent;
    }

    public World getWorld() {
        return this.getLocation().getWorld();
    }

    public World GetWorld() {
        return this.getWorld();
    }

    public Location getLocation() {
        return this.location;
    }

    public Location GetLocation() {
        return this.location;
    }

    public ArmorStand getArmorStandDisplay() {
        return this.display;
    }

    public ArmorStand GetArmorStandDisplay() {
        return this.display;
    }

    public String getDisplayUUID() {
        return this.displayUUID;
    }

    public String GetDisplayUUID() {
        return this.displayUUID;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public UUID GetOwnerUUID() {
        return this.ownerUUID;
    }

    public OfflinePlayer getOwner() {
        return this.owner;
    }

    public OfflinePlayer GetOwner() {
        return this.owner;
    }

    public void SetOwner(UUID ownerUUIDpotential) {
        OfflinePlayer player;
        this.ownerUUID = ownerUUIDpotential;
        if (this.ownerUUID != null && (player = Bukkit.getOfflinePlayer((UUID)ownerUUIDpotential)).hasPlayedBefore()) {
            this.owner = player;
        }
    }

    public void SetOwner(OfflinePlayer basicOwner) {
        this.ownerUUID = basicOwner.getUniqueId();
        if (basicOwner.hasPlayedBefore()) {
            this.owner = basicOwner;
        }
    }

    public OptimizedTimeFormat getLastGenerationDate() {
        return this.lastGenerationDate;
    }

    public OptimizedTimeFormat GetLastGenerationDate() {
        return this.lastGenerationDate;
    }

    public void Fertilize() {
        this.fertilizerMultiplier *= this.getParent().fertilizerEfficiency;
    }

    public double GetFeFF() {
        return this.fertilizerMultiplier;
    }

    public boolean IsLoaded() {
        return this.chunkLoaded;
    }

    public void SetLoaded() {
        this.chunkLoaded = true;
    }

    public void SetUnloaded() {
        this.chunkLoaded = false;
    }

    public OptimizedTimeFormat getLastTimeConditionsWerentMet() {
        return this.lastTimeConditionsNotMet;
    }

    public OptimizedTimeFormat GetLastTimeConditionsWerentMet() {
        return this.lastTimeConditionsNotMet;
    }

    public Material getNativeMat() {
        return this.nativeMat;
    }

    public boolean HasNativeMat() {
        return this.nativeMat != null;
    }

    public void SetNativeMat(Material nativity) {
        this.nativeMat = nativity;
    }

    public int getCummulativeGenerations() {
        return this.generations;
    }

    public int getCurrentCount() {
        return this.currentCount;
    }

    public int GetCummulativeGenerations() {
        return this.generations;
    }

    public int GetCurrentCount() {
        return this.currentCount;
    }

    public int GetChunkX() {
        return this.chunkX;
    }

    public int GetChunkZ() {
        return this.chunkZ;
    }

    public int getChunkX() {
        return this.GetChunkX();
    }

    public int getChunkZ() {
        return this.GetChunkZ();
    }

    public MMOItem_Shrub_Instance(long intID, MMOItem_Shrub parentType, Location loc, String armorStandDisplayUUID, OptimizedTimeFormat lastGen, OptimizedTimeFormat lastCond, int totalGen, int currentGen, String mOrigin_Type, String mOrigin_ID) {
        this.internalID = intID;
        this.parent = parentType;
        this.location = loc;
        this.chunkX = (int)Math.floor((double)loc.getBlockX() / 16.0);
        this.chunkZ = (int)Math.floor((double)loc.getBlockZ() / 16.0);
        this.nativeMat = null;
        this.displayUUID = OotilityCeption.UUIDFromString((String)armorStandDisplayUUID) != null ? armorStandDisplayUUID : "null";
        this.lastGenerationDate = lastGen;
        this.lastTimeConditionsNotMet = lastCond;
        this.generations = totalGen;
        this.currentCount = currentGen;
        if (mOrigin_ID != null && mOrigin_Type != null) {
            this.mmoitem_type_origin = mOrigin_Type;
            this.mmoitem_id_origin = mOrigin_ID;
        } else {
            this.mmoitem_type_origin = "null";
            this.mmoitem_id_origin = "null";
        }
    }

    public void DisplayLinkAttempt(ArrayList<ExtraneousArmorStand> possibleEntities) {
        if (this.displayUUID == null) {
            return;
        }
        if (this.displayUUID.equals("null")) {
            return;
        }
        ArmorStand aStand = null;
        for (ExtraneousArmorStand eas : possibleEntities) {
            UUID tEAS = OotilityCeption.UUIDFromString((String)this.displayUUID);
            if (tEAS == null || !eas.Compare(tEAS)) continue;
            aStand = eas.getEntity();
            eas.SetValid();
            break;
        }
        if (aStand != null) {
            this.display = aStand;
        } else {
            this.display = null;
            this.displayUUID = "null";
        }
    }

    public boolean CheckConditions() {
        boolean ret = true;
        Boolean weatherRet = null;
        Boolean daytimeRet = null;
        Boolean altitudeRet = null;
        Boolean dimensionalRet = null;
        Boolean adventureRet = null;
        Boolean cappedRet = null;
        for (MMOItem_Shrub_Conditions cond : this.getParent().getConditions()) {
            switch (cond) {
                case UNCAPPED: {
                    if (this.currentCount < this.getParent().maxCapacity) {
                        cappedRet = true;
                        break;
                    }
                    if (cappedRet != null) break;
                    cappedRet = false;
                    break;
                }
                case RAIN: {
                    if (this.getWorld().hasStorm()) {
                        weatherRet = true;
                        break;
                    }
                    if (weatherRet != null) break;
                    weatherRet = false;
                    break;
                }
                case THUNDER: {
                    if (this.getWorld().isThundering()) {
                        weatherRet = true;
                        break;
                    }
                    if (weatherRet != null) break;
                    weatherRet = false;
                    break;
                }
                case SUNNY: {
                    if (!this.getWorld().hasStorm()) {
                        weatherRet = true;
                        break;
                    }
                    if (weatherRet != null) break;
                    weatherRet = false;
                    break;
                }
                case DAY: {
                    if (this.getWorld().getTime() >= 1000L && this.getWorld().getTime() <= 12000L) {
                        daytimeRet = true;
                        break;
                    }
                    if (daytimeRet != null) break;
                    daytimeRet = false;
                    break;
                }
                case NIGHT: {
                    if (this.getWorld().getTime() >= 13000L && this.getWorld().getTime() <= 23000L) {
                        daytimeRet = true;
                        break;
                    }
                    if (daytimeRet != null) break;
                    daytimeRet = false;
                    break;
                }
                case SUNSET: {
                    if (this.getWorld().getTime() >= 12000L && this.getWorld().getTime() <= 13000L) {
                        daytimeRet = true;
                        break;
                    }
                    if (daytimeRet != null) break;
                    daytimeRet = false;
                    break;
                }
                case DAWN: {
                    if (this.getWorld().getTime() >= 0L && this.getWorld().getTime() <= 1000L || this.getWorld().getTime() >= 23000L && this.getWorld().getTime() <= 24000L) {
                        daytimeRet = true;
                        break;
                    }
                    if (daytimeRet != null) break;
                    daytimeRet = false;
                    break;
                }
                case CAVERN: {
                    if (this.location.getY() <= (double)cavernEdge) {
                        altitudeRet = true;
                        break;
                    }
                    if (altitudeRet != null) break;
                    altitudeRet = false;
                    break;
                }
                case UNDERGROUND: {
                    if (this.location.getY() >= (double)cavernEdge && this.location.getY() <= (double)underEdge) {
                        altitudeRet = true;
                        break;
                    }
                    if (altitudeRet != null) break;
                    altitudeRet = false;
                    break;
                }
                case SURFACE: {
                    if (this.location.getY() >= (double)underEdge && this.location.getY() <= (double)surfaceEdge) {
                        altitudeRet = true;
                        break;
                    }
                    if (altitudeRet != null) break;
                    altitudeRet = false;
                    break;
                }
                case SKY: {
                    if (this.location.getY() >= (double)surfaceEdge && this.location.getY() <= (double)skyEdge) {
                        altitudeRet = true;
                        break;
                    }
                    if (altitudeRet != null) break;
                    altitudeRet = false;
                    break;
                }
                case SPACE: {
                    if (this.location.getY() >= (double)skyEdge) {
                        altitudeRet = true;
                        break;
                    }
                    if (altitudeRet != null) break;
                    altitudeRet = false;
                    break;
                }
                case OVERWORLD: {
                    if (this.getWorld().getEnvironment() == World.Environment.NORMAL) {
                        dimensionalRet = true;
                        break;
                    }
                    if (dimensionalRet != null) break;
                    dimensionalRet = false;
                    break;
                }
                case NETHER: {
                    if (this.getWorld().getEnvironment() == World.Environment.NETHER) {
                        dimensionalRet = true;
                        break;
                    }
                    if (dimensionalRet != null) break;
                    dimensionalRet = false;
                    break;
                }
                case END: {
                    if (this.getWorld().getEnvironment() == World.Environment.THE_END) {
                        dimensionalRet = true;
                        break;
                    }
                    if (dimensionalRet != null) break;
                    dimensionalRet = false;
                    break;
                }
                case NEARLANDS: {
                    if (OotilityCeption.SumAsVectors((double)this.location.getBlockX(), (double)this.location.getBlockZ()) < (double)nearEdge) {
                        adventureRet = true;
                        break;
                    }
                    if (adventureRet != null) break;
                    adventureRet = false;
                    break;
                }
                case MEDIUMLANDS: {
                    if (OotilityCeption.SumAsVectors((double)this.location.getBlockX(), (double)this.location.getBlockZ()) > (double)nearEdge) {
                        if (OotilityCeption.SumAsVectors((double)this.location.getBlockX(), (double)this.location.getBlockZ()) < (double)farEdge) {
                            adventureRet = true;
                            break;
                        }
                    }
                    if (adventureRet != null) break;
                    adventureRet = false;
                    break;
                }
                case FARLANDS: {
                    if (OotilityCeption.SumAsVectors((double)this.location.getBlockX(), (double)this.location.getBlockZ()) > (double)farEdge) {
                        adventureRet = true;
                        break;
                    }
                    if (adventureRet != null) break;
                    adventureRet = false;
                }
            }
        }
        if (weatherRet != null) {
            boolean bl = ret = ret && weatherRet != false;
        }
        if (daytimeRet != null) {
            boolean bl = ret = ret && daytimeRet != false;
        }
        if (altitudeRet != null) {
            boolean bl = ret = ret && altitudeRet != false;
        }
        if (dimensionalRet != null) {
            boolean bl = ret = ret && dimensionalRet != false;
        }
        if (adventureRet != null) {
            boolean bl = ret = ret && adventureRet != false;
        }
        if (cappedRet != null) {
            boolean bl = ret = ret && cappedRet != false;
        }
        if (!ret) {
            this.lastTimeConditionsNotMet = new OptimizedTimeFormat(OptimizedTimeFormat.GetCurrentTime());
        }
        return ret;
    }

    public void GenerateProduce(int amount) {
        this.currentCount += amount;
        this.generations += amount;
        this.lastGenerationDate = OptimizedTimeFormat.Convert((String)OptimizedTimeFormat.GetCurrentTime());
        this.fertilizerMultiplier = 1.0;
        this.AdjustDisplay();
        MMOItem_Shrub_Manager.SaveShrubInstanceTimes(this.internalID, this.lastGenerationDate, this.lastTimeConditionsNotMet);
    }

    public void AutodropProduce(int amount) {
        this.generations += amount;
        this.lastGenerationDate = OptimizedTimeFormat.Convert((String)OptimizedTimeFormat.GetCurrentTime());
        this.fertilizerMultiplier = 1.0;
        this.getParent().RunCommandOnShake(null, this);
        this.DropProduce(amount);
        MMOItem_Shrub_Manager.SaveShrubInstanceTimes(this.internalID, this.lastGenerationDate, this.lastTimeConditionsNotMet);
    }

    public void TreeInit() {
        this.lastGenerationDate = OptimizedTimeFormat.Convert((String)OptimizedTimeFormat.GetCurrentTime());
        ++this.lastGenerationDate.year;
        if (MMOItem_Shrubs.realtimeSaving) {
            MMOItem_Shrub_Manager.SaveShrubInstanceQuantities(this.internalID, this.generations, this.currentCount);
            MMOItem_Shrub_Manager.SaveShrubInstanceTimes(this.internalID, this.lastGenerationDate, this.lastTimeConditionsNotMet);
        }
    }

    public void NativeCheck() {
        if (!this.HasNativeMat()) {
            return;
        }
        if (this.getLocation().getBlock().getType() != this.nativeMat) {
            this.Shake(null, null);
            this.Unregister(true);
        }
    }

    public void Shake(Player as, ItemStack with) {
        boolean shakeSuccess = this.getParent().CanBeShookWith(with);
        boolean protectedFail = MMOItem_Shrub_Manager.ShrubProtectedAgainst(as, this.getLocation());
        if (protectedFail && MMOItem_Shrubs.protectedShrubMessage != null) {
            as.sendMessage(OotilityCeption.ParseColour((String)OotilityCeption.ParseConsoleCommand((String)MMOItem_Shrub.ParseAsShrub(MMOItem_Shrubs.protectedShrubMessage, this), (Entity)as, (Player)as, (Block)this.getLocation().getBlock(), (ItemStack)with)));
        }
        boolean bl = shakeSuccess = shakeSuccess && this.getParent().VaultCanShake(as) && !protectedFail;
        if (shakeSuccess && this.currentCount > 0) {
            if (this.getParent().HarvestReset() && this.currentCount == this.getParent().getMaxCapacity()) {
                this.lastGenerationDate = OptimizedTimeFormat.Convert((String)OptimizedTimeFormat.GetCurrentTime());
                MMOItem_Shrub_Manager.SaveShrubInstanceTimes(this.internalID, this.lastGenerationDate, this.lastTimeConditionsNotMet);
            }
            this.getParent().VaultShakeApply(as);
            this.getParent().RunCommandOnShake(as, this);
            this.VaultRevenue();
            this.DropProduce();
        }
    }

    void VaultRevenue() {
        if (Gunging_Ootilities_Plugin.foundVault.booleanValue() && this.getParent().HasVaultRevenue() && this.owner != null) {
            PlusMinusPercent pmp = this.getParent().VaultRevenueOperation();
            GooPVault.SetPlayerBalance((OfflinePlayer)this.owner, (PlusMinusPercent)pmp, (boolean)false);
        }
    }

    public void DropProduce() {
        this.DropProduce(null);
    }

    public void DropProduce(Integer asAutoDrop) {
        if (this.currentCount == 0 && asAutoDrop == null) {
            return;
        }
        if (!OotilityCeption.IsAirNullAllowed((ItemStack)this.getParent().mmoitem_Generated)) {
            int kount = this.currentCount;
            if (asAutoDrop != null) {
                kount = asAutoDrop;
            }
            for (int i = 1; i <= kount; ++i) {
                this.getWorld().dropItem(this.NextRandomDropLocation(), this.getParent().mmoitem_Generated);
                if (!this.getParent().ForcesRegeneration()) continue;
                this.getParent().RegenerateGenerated(false);
            }
        }
        if (asAutoDrop == null) {
            this.currentCount = 0;
        }
        MMOItem_Shrub_Manager.SaveShrubInstanceQuantities(this.internalID, this.generations, this.currentCount);
        if (asAutoDrop == null) {
            this.AdjustDisplay();
        }
        if (this.getParent().getMaxResources() != null && this.getParent().getMaxResources() <= this.getCummulativeGenerations()) {
            this.Unregister(false);
            this.getWorld().getBlockAt(this.getLocation()).breakNaturally(null);
        }
    }

    public Location NextRandomDropLocation() {
        double xShift = 0.5;
        double yShift = 0.5;
        double zShift = 0.5;
        if (!this.getLocation().getBlock().isPassable()) {
            for (int freeSide = 0; freeSide <= 6; ++freeSide) {
                if (freeSide == 0) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.DOWN).getType())) continue;
                    xShift = 0.5;
                    yShift = -0.5;
                    zShift = 0.5;
                    break;
                }
                if (freeSide == 1) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.UP).getType())) continue;
                    xShift = 0.5;
                    yShift = 1.5;
                    zShift = 0.5;
                    break;
                }
                if (freeSide == 2) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.NORTH).getType())) continue;
                    xShift = 0.5;
                    yShift = 0.5;
                    zShift = -0.5;
                    break;
                }
                if (freeSide == 3) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.SOUTH).getType())) continue;
                    xShift = 0.5;
                    yShift = 0.5;
                    zShift = 1.5;
                    break;
                }
                if (freeSide == 4) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.WEST).getType())) continue;
                    xShift = -0.5;
                    yShift = 0.5;
                    zShift = 0.5;
                    break;
                }
                if (freeSide == 5) {
                    if (!OotilityCeption.IsAir((Material)this.getLocation().getBlock().getRelative(BlockFace.EAST).getType())) continue;
                    xShift = 1.5;
                    yShift = 0.5;
                    zShift = 0.5;
                    break;
                }
                xShift = 0.5;
                yShift = 0.5;
                zShift = 0.5;
                break;
            }
        }
        return new Location(this.getWorld(), xShift, yShift, zShift).add(this.GetLocation());
    }

    public void MarkForDestruction() {
        this.markForDestruction = true;
    }

    public void Unregister(boolean withDrop) {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (withDrop) {
            double lative = this.getCummulativeGenerations();
            double resources = 1.0;
            if (this.getParent().getMaxResources() != null) {
                double max = this.getParent().getMaxResources().intValue();
                double fraction = lative / max;
                resources = 1.0 - fraction;
            }
            if (resources > this.getParent().GetRecovery()) {
                if (!this.mmoitem_type_origin.equals("null") && !this.getParent().IsSeeds()) {
                    ItemStack drop = GooPMMOItems.GetMMOItemOrDefault((String)this.mmoitem_type_origin, (String)this.mmoitem_id_origin);
                    this.getWorld().dropItem(new Location(this.getWorld(), 0.5, 0.0, 0.5).add(this.getLocation()), drop);
                } else if (this.HasNativeMat() && !this.getParent().IsSeeds() && !OotilityCeption.IsAir((Material)this.nativeMat)) {
                    this.getWorld().dropItem(new Location(this.getWorld(), 0.5, 0.0, 0.5).add(this.getLocation()), new ItemStack(this.nativeMat));
                }
            }
        }
        MMOItem_Shrub_Manager.DeleteShrubInstance(this.internalID);
        this.getParent().instances.remove(this);
        MMOItem_Shrub_Manager.shrubInstanceLink.remove(this.internalID);
        MMOItem_Shrub_Manager.instanceShrubStorages.remove(this.internalID);
        MMOItem_Shrub_Instance inst = MMOItem_Shrub_Manager.GetShrubAt(this.getLocation());
        if (inst != null) {
            if (inst.internalID == this.internalID) {
                MMOItem_Shrub_Manager.SetShrubAt(this.getLocation(), null);
            } else {
                this.display = (ArmorStand)OotilityCeption.getEntityByUniqueId((String)this.displayUUID);
                if (this.display != null) {
                    this.getArmorStandDisplay().remove();
                }
            }
        } else {
            this.display = (ArmorStand)OotilityCeption.getEntityByUniqueId((String)this.displayUUID);
            if (this.display != null) {
                this.getArmorStandDisplay().remove();
            }
        }
        if (this.getArmorStandDisplay() != null) {
            this.getArmorStandDisplay().remove();
            this.display = null;
        }
    }

    public void UpdatePosition(Location newLoc, boolean manualRemove) {
        if (!manualRemove) {
            MMOItem_Shrub_Manager.SetShrubAt(this.getLocation(), null);
        }
        MMOItem_Shrub_Manager.SetShrubAt(newLoc, this);
        this.location = newLoc;
        this.chunkX = newLoc.getChunk().getX();
        this.chunkZ = newLoc.getChunk().getZ();
        if (MMOItem_Shrubs.realtimeLocation) {
            MMOItem_Shrub_Manager.SaveShrubInstanceLocation(this.internalID, newLoc);
        }
        this.RepositionDisplay();
    }

    void SetDisplayItem(EquipmentSlot slot, ItemStack itm) {
        EntityEquipment equ;
        if (this.display != null && (equ = this.display.getEquipment()) != null) {
            switch (slot) {
                default: {
                    this.getArmorStandDisplay().getEquipment().setItemInMainHand(itm);
                    break;
                }
                case HEAD: {
                    this.getArmorStandDisplay().getEquipment().setHelmet(itm);
                    break;
                }
                case CHEST: {
                    this.getArmorStandDisplay().getEquipment().setChestplate(itm);
                    break;
                }
                case LEGS: {
                    this.getArmorStandDisplay().getEquipment().setLeggings(itm);
                    break;
                }
                case FEET: {
                    this.getArmorStandDisplay().getEquipment().setBoots(itm);
                    break;
                }
                case OFF_HAND: {
                    this.getArmorStandDisplay().getEquipment().setItemInOffHand(itm);
                }
            }
        }
    }

    public void AdjustDisplay() {
        if (MMOItem_Shrubs.useArmorStands && this.IsLoaded()) {
            this.CorroborateDisplay();
            if (!this.basePoseRegeneration) {
                this.RegenDisplayPose(this.getParent().type);
            }
            if (this.currentCount > 0) {
                this.SetDisplayItem(EquipmentSlot.HEAD, this.getParent().mmoitem_Generated);
                double cap = this.getParent().getMaxCapacity();
                if (cap > 1.0) {
                    if ((double)this.currentCount == cap) {
                        this.SetDisplayItem(EquipmentSlot.HAND, this.getParent().mmoitem_Generated);
                    } else {
                        this.SetDisplayItem(EquipmentSlot.HAND, null);
                    }
                    if (cap >= 3.0) {
                        if ((double)this.currentCount / cap > 0.5) {
                            this.SetDisplayItem(EquipmentSlot.OFF_HAND, this.getParent().mmoitem_Generated);
                        } else {
                            this.SetDisplayItem(EquipmentSlot.OFF_HAND, null);
                        }
                    }
                }
            } else {
                this.SetDisplayItem(EquipmentSlot.HEAD, null);
                this.SetDisplayItem(EquipmentSlot.HAND, null);
                this.SetDisplayItem(EquipmentSlot.OFF_HAND, null);
            }
        }
    }

    void CorroborateDisplay() {
        if (!MMOItem_Shrubs.useArmorStands || this.destroyed) {
            return;
        }
        if (!this.IsLoaded()) {
            return;
        }
        boolean reGen = false;
        if (this.getArmorStandDisplay() == null) {
            reGen = true;
        } else if (this.getArmorStandDisplay().isDead() || !this.getArmorStandDisplay().isValid()) {
            reGen = true;
        }
        if (reGen) {
            this.display = (ArmorStand)this.getWorld().spawnEntity(new Location(this.getWorld(), 0.0, 0.0, 0.0), EntityType.ARMOR_STAND);
            this.displayUUID = this.display.getUniqueId().toString();
            this.display.setInvulnerable(true);
            this.display.setMarker(true);
            this.display.setVisible(false);
            this.display.setGravity(false);
            this.display.setSilent(true);
            this.display.addScoreboardTag("MMOItem_Shrub");
            this.basePoseRegeneration = false;
            this.getArmorStandDisplay().teleport(this.GetDisplayLocation(this.getParent().getType()));
            MMOItem_Shrub_Manager.SaveShrubInstanceArmorStand(this.internalID, this.displayUUID);
        }
    }

    public void RegenDisplayPose(AlternativeTypes as) {
        if (this.display != null && this.getArmorStandDisplay().isValid() && !this.getArmorStandDisplay().isDead()) {
            this.basePoseRegeneration = true;
            switch (as) {
                default: {
                    this.getArmorStandDisplay().setSmall(true);
                    this.getArmorStandDisplay().setHeadPose(new EulerAngle(this.Rads(180.0), 0.0, 0.0));
                    this.getArmorStandDisplay().setRightArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)0, (int)360)), 0.0, this.Rads(90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                    this.getArmorStandDisplay().setLeftArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)0, (int)360)), 0.0, this.Rads(360.0 - 90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                    break;
                }
                case VAT: {
                    this.getArmorStandDisplay().setSmall(false);
                    this.getArmorStandDisplay().setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                    this.getArmorStandDisplay().setRightArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)160, (int)250)), 0.0, this.Rads(90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                    this.getArmorStandDisplay().setLeftArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)160, (int)250)), 0.0, this.Rads(360.0 - 90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                    break;
                }
                case PEEK: {
                    this.getArmorStandDisplay().setSmall(true);
                    this.getArmorStandDisplay().setHeadPose(new EulerAngle(0.0, 0.0, 0.0));
                    this.getArmorStandDisplay().setRightArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)0, (int)360)), 0.0, this.Rads(90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                    this.getArmorStandDisplay().setLeftArmPose(new EulerAngle(this.Rads(OotilityCeption.GetRandomInt((int)0, (int)360)), 0.0, this.Rads(360.0 - 90.0 * (double)OotilityCeption.GetRandomInt((int)0, (int)1))));
                }
            }
        }
        this.RepositionDisplay();
    }

    public void Spark(AlternativeTypes as) {
        if (this.destroyed) {
            return;
        }
        if (!this.markForDestruction) {
            if (this.getArmorStandDisplay() != null) {
                if (!MMOItem_Shrubs.useArmorStands) {
                    this.DestroyDisplay();
                } else {
                    this.CorroborateDisplay();
                    this.RegenDisplayPose(as);
                    if (this.getParent().getGlowing()) {
                        this.getArmorStandDisplay().setFireTicks(Short.MAX_VALUE);
                    } else {
                        this.getArmorStandDisplay().setFireTicks(0);
                    }
                }
            }
        } else {
            this.Unregister(true);
        }
    }

    double Rads(double degs) {
        return degs * Math.PI / 180.0;
    }

    Location GetDisplayLocation(AlternativeTypes as) {
        switch (this.getParent().getType()) {
            case VAT: {
                if (this.getParent().glowing) {
                    return new Location(this.getWorld(), 0.5, -0.2, 0.5).add(this.GetLocation());
                }
                return new Location(this.getWorld(), 0.5, 0.01, 0.5).add(this.GetLocation());
            }
        }
        return new Location(this.getWorld(), 0.5, 0.0, 0.5).add(this.GetLocation());
    }

    void RepositionDisplay() {
        if (this.getArmorStandDisplay() != null && this.getArmorStandDisplay().isValid() && !this.getArmorStandDisplay().isDead()) {
            this.getArmorStandDisplay().teleport(this.GetDisplayLocation(this.getParent().getType()));
        }
    }

    public void DestroyDisplay() {
        if (this.getArmorStandDisplay() != null) {
            this.getArmorStandDisplay().remove();
            this.displayUUID = "null";
            MMOItem_Shrub_Manager.SaveShrubInstanceArmorStand(this.internalID, this.displayUUID);
        }
    }
}

