/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.version.lookup.handle;

import com.github.sachin.lootin.version.lookup.handle.ClassLookup;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ClassLookupCache {
    protected final HashMap<String, ClassLookup> cache = new HashMap();

    public void clear() {
        this.cache.values().forEach(ClassLookup::delete);
        this.cache.clear();
    }

    public Optional<ClassLookup> get(String name) {
        return Optional.ofNullable(this.cache.get(name));
    }

    public boolean has(String name) {
        return this.cache.containsKey(name);
    }

    public ClassLookup create(String name, String path) {
        if (this.has(name)) {
            return this.cache.get(name);
        }
        ClassLookup reflect = this.create(path);
        this.cache.put(name, reflect);
        return reflect;
    }

    public ClassLookup create(String name, Class<?> clazz) {
        if (this.has(name)) {
            return this.cache.get(name);
        }
        ClassLookup reflect = this.create(clazz);
        this.cache.put(name, reflect);
        return reflect;
    }

    public void delete(String name) {
        this.cache.remove(name);
    }

    public Map.Entry<String, ClassLookup>[] entries() {
        return (Map.Entry[])this.cache.entrySet().toArray(Map.Entry[]::new);
    }

    private ClassLookup create(Class<?> clazz) {
        return ClassLookup.of(clazz);
    }

    private ClassLookup create(String path) {
        return ClassLookup.of(path);
    }
}

