/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.version.lookup.handle;

import com.github.sachin.lootin.utils.ArrayUtils;
import com.github.sachin.lootin.utils.ReflectionUtils;
import com.github.sachin.lootin.version.lookup.handle.field.IFieldHandle;
import com.github.sachin.lootin.version.lookup.handle.field.SafeFieldHandle;
import com.github.sachin.lootin.version.lookup.handle.field.UnsafeDeclaredFieldHandle;
import com.github.sachin.lootin.version.lookup.handle.field.UnsafeStaticFieldHandle;
import com.syntaxphoenix.syntaxapi.reflection.ClassCache;
import com.syntaxphoenix.syntaxapi.utils.java.Exceptions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Predicate;

public class ClassLookup {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private Class<?> owner;
    private MethodHandles.Lookup privateLookup;
    private final HashMap<String, MethodHandle> constructors = new HashMap();
    private final HashMap<String, MethodHandle> methods = new HashMap();
    private final HashMap<String, IFieldHandle<?>> fields = new HashMap();

    protected ClassLookup(String classPath) throws IllegalAccessException {
        this(ClassCache.getClass((String)classPath));
    }

    protected ClassLookup(Class<?> owner) throws IllegalAccessException {
        this.owner = owner;
        this.privateLookup = owner != null ? MethodHandles.privateLookupIn(owner, LOOKUP) : null;
    }

    public Class<?> getOwner() {
        return this.owner;
    }

    public MethodHandles.Lookup getPrivateLockup() {
        return this.privateLookup;
    }

    public void delete() {
        this.constructors.clear();
        this.methods.clear();
        this.fields.clear();
        this.owner = null;
        this.privateLookup = null;
    }

    public boolean isValid() {
        return this.owner != null;
    }

    public Collection<MethodHandle> getConstructors() {
        return this.constructors.values();
    }

    public Collection<MethodHandle> getMethods() {
        return this.methods.values();
    }

    public Collection<IFieldHandle<?>> getFields() {
        return this.fields.values();
    }

    public MethodHandle getConstructor(String name) {
        return this.isValid() ? this.constructors.get(name) : null;
    }

    public MethodHandle getMethod(String name) {
        return this.isValid() ? this.methods.get(name) : null;
    }

    public IFieldHandle<?> getField(String name) {
        return this.isValid() ? this.fields.get(name) : null;
    }

    public boolean hasConstructor(String name) {
        return this.isValid() && this.constructors.containsKey(name);
    }

    public boolean hasMethod(String name) {
        return this.isValid() && this.methods.containsKey(name);
    }

    public boolean hasField(String name) {
        return this.isValid() && this.fields.containsKey(name);
    }

    public Object init() {
        if (!this.isValid()) {
            return null;
        }
        MethodHandle handle = this.constructors.computeIfAbsent("$base#empty", ignore -> {
            try {
                return LOOKUP.unreflectConstructor(this.owner.getConstructor(new Class[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
        if (handle == null) {
            this.constructors.remove("$base#empty");
            return null;
        }
        try {
            return handle.invoke();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object init(String name, Object ... args) {
        if (!this.isValid() || !this.constructors.containsKey(name)) {
            return null;
        }
        try {
            return this.constructors.get(name).invokeWithArguments(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ClassLookup execute(String name, Object ... args) {
        this.run(name, args);
        return this;
    }

    public ClassLookup execute(Object source, String name, Object ... args) {
        this.run(source, name, args);
        return this;
    }

    public Object run(String name, Object ... args) {
        if (!this.isValid() || !this.methods.containsKey(name)) {
            return null;
        }
        try {
            return this.methods.get(name).invokeWithArguments(args);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object run(Object source, String name, Object ... args) {
        if (!this.isValid() || !this.methods.containsKey(name)) {
            return null;
        }
        try {
            return this.methods.get(name).invokeWithArguments(ClassLookup.mergeBack(args, source));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object getFieldValue(String name) {
        return this.isValid() && this.fields.containsKey(name) ? this.fields.get(name).getValue() : null;
    }

    public Object getFieldValue(Object source, String name) {
        return this.isValid() && this.fields.containsKey(name) ? this.fields.get(name).getValue(source) : null;
    }

    public void setFieldValue(String name, Object value) {
        if (!this.isValid() || !this.fields.containsKey(name)) {
            return;
        }
        this.fields.get(name).setValue(value);
    }

    public void setFieldValue(Object source, String name, Object value) {
        if (!this.isValid() || !this.fields.containsKey(name)) {
            return;
        }
        this.fields.get(name).setValue(source, value);
    }

    public ClassLookup searchConstructor(Predicate<ClassLookup> predicate, String name, Class<?> ... args) {
        return predicate.test(this) ? this.searchConstructor(name, args) : this;
    }

    public ClassLookup searchConstructor(String name, Class<?> ... arguments) {
        if (this.hasConstructor(name)) {
            return this;
        }
        Constructor<?> constructor = null;
        try {
            constructor = this.owner.getDeclaredConstructor(arguments);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (constructor == null) {
            try {
                constructor = this.owner.getConstructor(arguments);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (constructor != null) {
            try {
                this.constructors.put(name, this.unreflect(constructor));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this;
    }

    public ClassLookup searchConstructorsByArguments(String base, Class<?> ... arguments) {
        Constructor<?>[] constructors = ArrayUtils.merge(Constructor[]::new, this.owner.getDeclaredConstructors(), this.owner.getConstructors());
        if (constructors.length == 0) {
            return this;
        }
        base = (String)base + "-";
        int current = 0;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] args = constructor.getParameterTypes();
            if (args.length != arguments.length) continue;
            try {
                if (!ReflectionUtils.hasSameArguments(arguments, args)) continue;
                this.constructors.put((String)base + current, this.unreflect(constructor));
                ++current;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this;
    }

    public ClassLookup searchMethod(Predicate<ClassLookup> predicate, String name, String methodName, Class<?> ... arguments) {
        return predicate.test(this) ? this.searchMethod(name, methodName, arguments) : this;
    }

    public ClassLookup searchMethod(String name, String methodName, Class<?> ... arguments) {
        if (this.hasMethod(name)) {
            return this;
        }
        Method method = null;
        try {
            method = this.owner.getDeclaredMethod(methodName, arguments);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = this.owner.getMethod(methodName, arguments);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        if (method != null) {
            try {
                this.methods.put(name, this.unreflect(method));
            }
            catch (IllegalAccessException | SecurityException e) {
                System.out.println(Exceptions.stackTraceToString((Throwable)e));
            }
        }
        return this;
    }

    public ClassLookup searchMethodsByArguments(String base, Class<?> ... arguments) {
        Method[] methods = ArrayUtils.merge(Method[]::new, this.owner.getDeclaredMethods(), this.owner.getMethods());
        if (methods.length == 0) {
            return this;
        }
        base = (String)base + "-";
        int current = 0;
        for (Method method : methods) {
            Class<?>[] args = method.getParameterTypes();
            if (args.length != arguments.length) continue;
            try {
                if (!ReflectionUtils.hasSameArguments(arguments, args)) continue;
                this.methods.put((String)base + current, this.unreflect(method));
                ++current;
            }
            catch (IllegalAccessException | SecurityException exception) {
                // empty catch block
            }
        }
        return this;
    }

    public ClassLookup searchField(Predicate<ClassLookup> predicate, String name, String fieldName, Class<?> type) {
        return predicate.test(this) ? this.searchField(name, fieldName, type) : this;
    }

    public ClassLookup searchField(String name, String fieldName) {
        if (this.hasMethod(name)) {
            return this;
        }
        Field field = null;
        try {
            field = this.owner.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        if (field == null) {
            try {
                field = this.owner.getField(fieldName);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (field != null) {
            this.storeField(name, field);
        }
        return this;
    }

    public ClassLookup searchField(String name, String fieldName, Class<?> type) {
        if (this.hasField(name)) {
            return this;
        }
        VarHandle handle = null;
        try {
            handle = this.privateLookup.findVarHandle(this.owner, fieldName, type);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        if (handle == null) {
            try {
                handle = this.privateLookup.findStaticVarHandle(this.owner, fieldName, type);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (handle != null) {
            this.fields.put(name, new SafeFieldHandle(handle));
        }
        return this;
    }

    public boolean putField(String name, Field field) {
        return this.putField(name, field, false);
    }

    public boolean putField(String name, Field field, boolean forceSafe) {
        if (field == null || name == null || field.getDeclaringClass() != this.owner || this.fields.containsKey(name)) {
            return false;
        }
        this.storeField(name, field, forceSafe);
        return true;
    }

    private void storeField(String name, Field field) {
        this.storeField(name, field, false);
    }

    private void storeField(String name, Field field, boolean forceSafe) {
        block4: {
            if (forceSafe || !Modifier.isFinal(field.getModifiers())) {
                try {
                    this.fields.put(name, new SafeFieldHandle(this.unreflect(field)));
                    return;
                }
                catch (IllegalAccessException | SecurityException e) {
                    if (!forceSafe) break block4;
                    return;
                }
            }
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            this.fields.put(name, new UnsafeDeclaredFieldHandle(field));
            return;
        }
        this.fields.put(name, new UnsafeStaticFieldHandle(field));
    }

    private VarHandle unreflect(Field field) throws IllegalAccessException, SecurityException {
        if (Modifier.isStatic(field.getModifiers())) {
            boolean access = field.canAccess(null);
            if (!access) {
                field.setAccessible(true);
            }
            VarHandle out = LOOKUP.unreflectVarHandle(field);
            if (!access) {
                field.setAccessible(false);
            }
            return out;
        }
        if (field.trySetAccessible()) {
            VarHandle out = LOOKUP.unreflectVarHandle(field);
            field.setAccessible(false);
            return out;
        }
        return LOOKUP.unreflectVarHandle(field);
    }

    private MethodHandle unreflect(Method method) throws IllegalAccessException, SecurityException {
        if (Modifier.isStatic(method.getModifiers())) {
            boolean access = method.canAccess(null);
            if (!access) {
                method.setAccessible(true);
            }
            MethodHandle out = LOOKUP.unreflect(method);
            if (!access) {
                method.setAccessible(false);
            }
            return out;
        }
        if (method.trySetAccessible()) {
            MethodHandle out = LOOKUP.unreflect(method);
            method.setAccessible(false);
            return out;
        }
        return LOOKUP.unreflect(method);
    }

    private MethodHandle unreflect(Constructor<?> constructor) throws IllegalAccessException {
        boolean access = constructor.canAccess(null);
        if (!access) {
            constructor.setAccessible(true);
        }
        MethodHandle out = LOOKUP.unreflectConstructor(constructor);
        if (!access) {
            constructor.setAccessible(false);
        }
        return out;
    }

    public static Object[] mergeBack(Object[] array1, Object ... array2) {
        Object[] output = new Object[array1.length + array2.length];
        System.arraycopy(array2, 0, output, 0, array2.length);
        System.arraycopy(array1, 0, output, array2.length, array1.length);
        return output;
    }

    public static final ClassLookup of(Class<?> clazz) {
        try {
            return new ClassLookup(clazz);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static final ClassLookup of(String path) {
        try {
            return new ClassLookup(path);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

