/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.version.lookup;

import com.github.sachin.lootin.utils.LConstants;
import com.github.sachin.lootin.utils.ReflectionUtils;
import com.github.sachin.lootin.version.lookup.handle.ClassLookup;
import com.github.sachin.lootin.version.lookup.handle.ClassLookupCache;
import com.github.sachin.lootin.version.lookup.handle.FakeLookup;
import java.util.Map;
import java.util.Optional;

public class ClassLookupProvider {
    public static final String CB_PATH_FORMAT = "org.bukkit.craftbukkit.%s.%s";
    public static final String NMS_PATH_FORMAT_LEGACY = "net.minecraft.server.%s.%s";
    public static final String NMS_PATH_FORMAT_REMAP = "net.minecraft.%s";
    protected final ClassLookupCache cache;
    protected final String cbPath;
    protected final String nmsPath;
    private boolean skip = false;

    public ClassLookupProvider() {
        this(new ClassLookupCache());
    }

    public ClassLookupProvider(ClassLookupCache cache) {
        this.cache = cache;
        this.cbPath = String.format(CB_PATH_FORMAT, LConstants.SERVER_VERSION, "%s");
        this.nmsPath = LConstants.SERVER_MINOR_VERSION >= 17 ? NMS_PATH_FORMAT_REMAP : String.format(NMS_PATH_FORMAT_LEGACY, LConstants.SERVER_VERSION, "%s");
    }

    public void deleteAll() {
        this.cache.clear();
    }

    public void deleteByName(String name) {
        this.cache.delete(name);
    }

    public void deleteByPackage(String path) {
        Map.Entry<String, ClassLookup>[] array;
        for (Map.Entry<String, ClassLookup> entry : array = this.cache.entries()) {
            if (!entry.getValue().getOwner().getPackageName().equals(path)) continue;
            this.cache.delete(entry.getKey());
        }
    }

    public ClassLookupProvider require(boolean skip) {
        this.skip = !skip;
        return this;
    }

    public ClassLookupProvider skip(boolean skip) {
        this.skip = skip;
        return this;
    }

    public boolean skip() {
        return this.skip;
    }

    public ClassLookupCache getReflection() {
        return this.cache;
    }

    public String getNmsPath() {
        return this.nmsPath;
    }

    public String getCbPath() {
        return this.cbPath;
    }

    public ClassLookup createNMSLookup(String name, String path) {
        return this.skip ? FakeLookup.FAKE : this.cache.create(name, this.getNMSClass(path));
    }

    public ClassLookup createCBLookup(String name, String path) {
        return this.skip ? FakeLookup.FAKE : this.cache.create(name, this.getCBClass(path));
    }

    public ClassLookup createLookup(String name, String path) {
        return this.skip ? FakeLookup.FAKE : this.cache.create(name, this.getClass(path));
    }

    public ClassLookup createLookup(String name, Class<?> clazz) {
        return this.skip ? FakeLookup.FAKE : this.cache.create(name, clazz);
    }

    public Optional<ClassLookup> getOptionalLookup(String name) {
        return this.cache.get(name);
    }

    public ClassLookup getLookup(String name) {
        return this.cache.get(name).orElse(null);
    }

    public Class<?> getNMSClass(String path) {
        return this.getClass(String.format(this.nmsPath, path));
    }

    public Class<?> getCBClass(String path) {
        return this.getClass(String.format(this.cbPath, path));
    }

    public Class<?> getClass(String path) {
        return ReflectionUtils.getClass(path);
    }
}

