/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.version;

import com.github.sachin.lootin.utils.LConstants;
import com.github.sachin.lootin.version.lookup.ClassLookupProvider;
import com.github.sachin.lootin.version.lookup.handle.ClassLookup;
import java.util.Optional;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.loot.Lootable;

public final class VersionProvider {
    public static final ClassLookupProvider PROVIDER = new ClassLookupProvider();

    private VersionProvider() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void setup() {
        VersionProvider.setupAll();
        if (LConstants.SERVER_REMAPPED) {
            VersionProvider.setupRemap();
            VersionProvider.setupSearch();
            return;
        }
        VersionProvider.setupLegacy();
        VersionProvider.setupSearch();
    }

    private static void setupLegacy() {
        PROVIDER.createNMSLookup("EntityHuman", "EntityHuman");
        PROVIDER.createNMSLookup("TileEntityLootable", "TileEntityLootable");
        PROVIDER.createNMSLookup("EntityMinecartContainer", "EntityMinecartContainer");
    }

    private static void setupRemap() {
        PROVIDER.createNMSLookup("EntityHuman", "world.entity.player.EntityHuman");
        PROVIDER.createNMSLookup("TileEntityLootable", "world.level.block.entity.TileEntityLootable");
        PROVIDER.createNMSLookup("EntityMinecartContainer", "world.entity.vehicle.EntityMinecartContainer");
    }

    private static void setupAll() {
        PROVIDER.createCBLookup("CraftBlockEntityState", "block.CraftBlockEntityState").searchMethod("handle", "getTileEntity", new Class[0]);
        PROVIDER.createCBLookup("CraftEntity", "entity.CraftEntity").searchMethod("handle", "getHandle", new Class[0]);
    }

    private static void setupSearch() {
        Class<?> human = PROVIDER.getLookup("EntityHuman").getOwner();
        PROVIDER.getLookup("TileEntityLootable").searchMethod("fill", "e", human).searchMethod("fill", "d", human);
        PROVIDER.getLookup("EntityMinecartContainer").searchMethod("fill", "e", human).searchMethod("fill", "d", human);
    }

    private static ClassLookup[] require(String ... names) {
        ClassLookup[] lookups = new ClassLookup[names.length];
        for (int index = 0; index < names.length; ++index) {
            Optional<ClassLookup> lookup = PROVIDER.getOptionalLookup(names[index]);
            if (lookup.isEmpty()) {
                throw new IllegalStateException("Lookup " + names[index] + " not found!");
            }
            lookups[index] = lookup.get();
        }
        return lookups;
    }

    public static void fillLoot(Player player, Lootable lootable) {
        if (lootable instanceof BlockState) {
            ClassLookup[] lookup = VersionProvider.require("CraftEntity", "CraftBlockEntityState", "TileEntityLootable");
            Object handle = lookup[1].run(lootable, "handle", new Object[0]);
            Object target = lookup[0].run(player, "handle", new Object[0]);
            lookup[2].execute(handle, "fill", target);
            return;
        }
        ClassLookup[] lookup = VersionProvider.require("CraftEntity", "EntityMinecartContainer");
        Object handle = lookup[0].run(lootable, "handle", new Object[0]);
        Object target = lookup[0].run(player, "handle", new Object[0]);
        lookup[1].execute(handle, "fill", target);
    }
}

