/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.utils.cooldown;

import com.github.sachin.lootin.utils.cooldown.Cooldown;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public final class CooldownTimer
extends TimerTask {
    private boolean alive = true;
    private boolean running = false;
    private final List<Cooldown> active = Collections.synchronizedList(new ArrayList());

    public CooldownTimer() {
        new Timer("Cooldown", true).scheduleAtFixedRate((TimerTask)this, 0L, 1L);
    }

    void add(Cooldown cooldown) {
        this.active.add(cooldown);
    }

    @Override
    public void run() {
        if (!this.running) {
            return;
        }
        for (Cooldown cooldown : this.active) {
            if (cooldown.isTriggerable()) continue;
            cooldown.decrement();
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void kill() {
        this.alive = false;
        this.cancel();
    }

    public boolean isAvailable() {
        return this.alive;
    }
}

