/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.lootin.utils.cooldown;

import com.github.sachin.lootin.utils.cooldown.Cooldown;
import com.github.sachin.lootin.utils.cooldown.CooldownTimer;
import java.util.HashMap;
import java.util.UUID;

public final class CooldownContainer {
    private final CooldownTimer timer;
    private final HashMap<UUID, Cooldown> cooldowns = new HashMap();
    private long cooldown = 200L;

    public CooldownContainer() {
        this(new CooldownTimer());
    }

    public CooldownContainer(CooldownTimer timer) {
        this.timer = timer;
    }

    public void setCooldown(long cooldown) {
        if (cooldown <= 0L) {
            throw new IllegalArgumentException("cooldown has to be higher than 0");
        }
        this.cooldown = cooldown;
        if (!this.cooldowns.isEmpty()) {
            for (Cooldown cooldownObj : this.cooldowns.values()) {
                cooldownObj.setCooldown(cooldown);
            }
        }
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public final CooldownTimer getTimer() {
        return this.timer;
    }

    public Cooldown get(UUID uniqueId) {
        return this.cooldowns.computeIfAbsent(uniqueId, ignore -> {
            Cooldown cooldownObj = new Cooldown(this.cooldown);
            this.timer.add(cooldownObj);
            return cooldownObj;
        });
    }
}

